/*
 * Decompiled with CFR 0.152.
 */
package replacecall.org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import replacecall.org.apache.bcel.Constants;
import replacecall.org.apache.bcel.classfile.ConstantPool;
import replacecall.org.apache.bcel.classfile.Node;
import replacecall.org.apache.bcel.classfile.Utility;
import replacecall.org.apache.bcel.classfile.Visitor;
import replacecall.org.checkerframework.checker.initialization.qual.Initialized;
import replacecall.org.checkerframework.checker.interning.qual.Interned;
import replacecall.org.checkerframework.checker.interning.qual.UnknownInterned;
import replacecall.org.checkerframework.checker.nullness.qual.NonNull;
import replacecall.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import replacecall.org.checkerframework.checker.signature.qual.SignatureUnknown;
import replacecall.org.checkerframework.dataflow.qual.SideEffectFree;

public final class CodeException
implements Cloneable,
Node,
Constants {
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int startPc;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int endPc;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int handlerPc;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int catchType;

    public CodeException(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown CodeException c) {
        this(c.getStartPC(), c.getEndPC(), c.getHandlerPC(), c.getCatchType());
    }

    CodeException(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataInput file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        this(file.readUnsignedShort(), file.readUnsignedShort(), file.readUnsignedShort(), file.readUnsignedShort());
    }

    public CodeException(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int startPc, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int endPc, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int handlerPc, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int catchType) {
        this.startPc = startPc;
        this.endPc = endPc;
        this.handlerPc = handlerPc;
        this.catchType = catchType;
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Visitor v) {
        v.visitCodeException(this);
    }

    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        file.writeShort(this.startPc);
        file.writeShort(this.endPc);
        file.writeShort(this.handlerPc);
        file.writeShort(this.catchType);
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getCatchType() {
        return this.catchType;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getEndPC() {
        return this.endPc;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getHandlerPC() {
        return this.handlerPc;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getStartPC() {
        return this.startPc;
    }

    public void setCatchType(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int catchType) {
        this.catchType = catchType;
    }

    public void setEndPC(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int endPc) {
        this.endPc = endPc;
    }

    public void setHandlerPC(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int handlerPc) {
        this.handlerPc = handlerPc;
    }

    public void setStartPC(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int startPc) {
        this.startPc = startPc;
    }

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        return "CodeException(startPc = " + this.startPc + ", endPc = " + this.endPc + ", handlerPc = " + this.handlerPc + ", catchType = " + this.catchType + ")";
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool cp, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean verbose) {
        String str = this.catchType == 0 ? "<Any exception>(0)" : Utility.compactClassName(cp.getConstantString(this.catchType, (byte)7), false) + (verbose ? "(" + this.catchType + ")" : "");
        return this.startPc + "\t" + this.endPc + "\t" + this.handlerPc + "\t" + str;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool cp) {
        return this.toString(cp, true);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown CodeException copy() {
        try {
            return (CodeException)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

