/*
 * Decompiled with CFR 0.152.
 */
package replacecall.org.apache.bcel.classfile;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import replacecall.org.apache.bcel.classfile.Attribute;
import replacecall.org.apache.bcel.classfile.ClassFormatException;
import replacecall.org.apache.bcel.classfile.ConstantPool;
import replacecall.org.apache.bcel.classfile.Field;
import replacecall.org.apache.bcel.classfile.JavaClass;
import replacecall.org.apache.bcel.classfile.Method;
import replacecall.org.checkerframework.checker.initialization.qual.Initialized;
import replacecall.org.checkerframework.checker.interning.qual.Interned;
import replacecall.org.checkerframework.checker.interning.qual.UnknownInterned;
import replacecall.org.checkerframework.checker.nullness.qual.NonNull;
import replacecall.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import replacecall.org.checkerframework.checker.signature.qual.SignatureUnknown;

public final class ClassParser {
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataInputStream dataInputStream;
    private final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean fileOwned;
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String fileName;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String zipFile;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int classNameIndex;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int superclassNameIndex;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int major;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int minor;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int accessFlags;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] interfaces;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constantPool;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Field @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] fields;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Method @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] methods;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Attribute @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] attributes;
    private final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean isZip;
    private static final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int BUFSIZE = 8192;

    public ClassParser(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InputStream inputStream, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String fileName) {
        this.fileName = fileName;
        this.fileOwned = false;
        String clazz = inputStream.getClass().getName();
        this.isZip = clazz.startsWith("java.util.zip.") || clazz.startsWith("java.util.jar.");
        this.dataInputStream = inputStream instanceof DataInputStream ? (DataInputStream)inputStream : new DataInputStream(new BufferedInputStream(inputStream, 8192));
    }

    public ClassParser(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String fileName) {
        this.isZip = false;
        this.fileName = fileName;
        this.fileOwned = true;
    }

    public ClassParser(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String zipFile, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String fileName) {
        this.isZip = true;
        this.fileOwned = true;
        this.zipFile = zipFile;
        this.fileName = fileName;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass parse() throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassFormatException {
        ZipFile zip = null;
        try {
            if (this.fileOwned) {
                if (this.isZip) {
                    zip = new ZipFile(this.zipFile);
                    ZipEntry entry = zip.getEntry(this.fileName);
                    if (entry == null) {
                        throw new IOException("File " + this.fileName + " not found");
                    }
                    this.dataInputStream = new DataInputStream(new BufferedInputStream(zip.getInputStream(entry), 8192));
                } else {
                    this.dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(this.fileName), 8192));
                }
            }
            this.readID();
            this.readVersion();
            this.readConstantPool();
            this.readClassInfo();
            this.readInterfaces();
            this.readFields();
            this.readMethods();
            this.readAttributes();
        }
        finally {
            if (this.fileOwned) {
                try {
                    if (this.dataInputStream != null) {
                        this.dataInputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
            try {
                if (zip != null) {
                    zip.close();
                }
            }
            catch (IOException iOException) {}
        }
        return new JavaClass(this.classNameIndex, this.superclassNameIndex, this.fileName, this.major, this.minor, this.accessFlags, this.constantPool, this.interfaces, this.fields, this.methods, this.attributes, this.isZip ? (byte)3 : 2);
    }

    private void readAttributes() throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassFormatException {
        int attributes_count = this.dataInputStream.readUnsignedShort();
        this.attributes = new Attribute[attributes_count];
        for (int i = 0; i < attributes_count; ++i) {
            this.attributes[i] = Attribute.readAttribute(this.dataInputStream, this.constantPool);
        }
    }

    private void readClassInfo() throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassFormatException {
        this.accessFlags = this.dataInputStream.readUnsignedShort();
        if ((this.accessFlags & 0x200) != 0) {
            this.accessFlags |= 0x400;
        }
        if ((this.accessFlags & 0x400) != 0 && (this.accessFlags & 0x10) != 0) {
            throw new ClassFormatException("Class " + this.fileName + " can't be both final and abstract");
        }
        this.classNameIndex = this.dataInputStream.readUnsignedShort();
        this.superclassNameIndex = this.dataInputStream.readUnsignedShort();
    }

    private void readConstantPool() throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassFormatException {
        this.constantPool = new ConstantPool(this.dataInputStream);
    }

    private void readFields() throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassFormatException {
        int fields_count = this.dataInputStream.readUnsignedShort();
        this.fields = new Field[fields_count];
        for (int i = 0; i < fields_count; ++i) {
            this.fields[i] = new Field((DataInput)this.dataInputStream, this.constantPool);
        }
    }

    private void readID() throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassFormatException {
        if (this.dataInputStream.readInt() != -889275714) {
            throw new ClassFormatException(this.fileName + " is not a Java .class file");
        }
    }

    private void readInterfaces() throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassFormatException {
        int interfaces_count = this.dataInputStream.readUnsignedShort();
        this.interfaces = new int[interfaces_count];
        for (int i = 0; i < interfaces_count; ++i) {
            this.interfaces[i] = this.dataInputStream.readUnsignedShort();
        }
    }

    private void readMethods() throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassFormatException {
        int methods_count = this.dataInputStream.readUnsignedShort();
        this.methods = new Method[methods_count];
        for (int i = 0; i < methods_count; ++i) {
            this.methods[i] = new Method((DataInput)this.dataInputStream, this.constantPool);
        }
    }

    private void readVersion() throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassFormatException {
        this.minor = this.dataInputStream.readUnsignedShort();
        this.major = this.dataInputStream.readUnsignedShort();
    }
}

