/*
 * Decompiled with CFR 0.152.
 */
package replacecall.org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import replacecall.org.apache.bcel.classfile.ConstantPool;
import replacecall.org.apache.bcel.classfile.Utility;
import replacecall.org.checkerframework.checker.initialization.qual.Initialized;
import replacecall.org.checkerframework.checker.interning.qual.Interned;
import replacecall.org.checkerframework.checker.interning.qual.UnknownInterned;
import replacecall.org.checkerframework.checker.nullness.qual.NonNull;
import replacecall.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import replacecall.org.checkerframework.checker.signature.qual.SignatureUnknown;
import replacecall.org.checkerframework.dataflow.qual.SideEffectFree;

public class BootstrapMethod
implements Cloneable {
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int bootstrapMethodRef;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] bootstrapArguments;

    public BootstrapMethod(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BootstrapMethod c) {
        this(c.getBootstrapMethodRef(), c.getBootstrapArguments());
    }

    BootstrapMethod(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataInput input) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        this(input.readUnsignedShort(), input.readUnsignedShort());
        for (int i = 0; i < this.bootstrapArguments.length; ++i) {
            this.bootstrapArguments[i] = input.readUnsignedShort();
        }
    }

    private BootstrapMethod(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int bootstrap_method_ref, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int num_bootstrap_arguments) {
        this(bootstrap_method_ref, new int[num_bootstrap_arguments]);
    }

    public BootstrapMethod(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int bootstrapMethodRef, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] bootstrapArguments) {
        this.bootstrapMethodRef = bootstrapMethodRef;
        this.bootstrapArguments = bootstrapArguments;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getBootstrapMethodRef() {
        return this.bootstrapMethodRef;
    }

    public void setBootstrapMethodRef(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int bootstrapMethodRef) {
        this.bootstrapMethodRef = bootstrapMethodRef;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getBootstrapArguments() {
        return this.bootstrapArguments;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getNumBootstrapArguments() {
        return this.bootstrapArguments.length;
    }

    public void setBootstrapArguments(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] bootstrapArguments) {
        this.bootstrapArguments = bootstrapArguments;
    }

    @SideEffectFree
    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        return "BootstrapMethod(" + this.bootstrapMethodRef + ", " + this.bootstrapArguments.length + ", " + Arrays.toString(this.bootstrapArguments) + ")";
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constantPool) {
        StringBuilder buf = new StringBuilder();
        String bootstrap_method_name = constantPool.constantToString(this.bootstrapMethodRef, (byte)15);
        buf.append(Utility.compactClassName(bootstrap_method_name, false));
        int num_bootstrap_arguments = this.bootstrapArguments.length;
        if (num_bootstrap_arguments > 0) {
            buf.append("\nMethod Arguments:");
            for (int i = 0; i < num_bootstrap_arguments; ++i) {
                buf.append("\n  ").append(i).append(": ");
                buf.append(constantPool.constantToString(constantPool.getConstant(this.bootstrapArguments[i])));
            }
        }
        return buf.toString();
    }

    public final void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        file.writeShort(this.bootstrapMethodRef);
        file.writeShort(this.bootstrapArguments.length);
        for (int bootstrap_argument : this.bootstrapArguments) {
            file.writeShort(bootstrap_argument);
        }
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BootstrapMethod copy() {
        try {
            return (BootstrapMethod)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

