/*
 * Decompiled with CFR 0.152.
 */
package replacecall.org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import replacecall.org.apache.bcel.classfile.AnnotationEntry;
import replacecall.org.apache.bcel.classfile.Attribute;
import replacecall.org.apache.bcel.classfile.ConstantPool;
import replacecall.org.apache.bcel.classfile.Visitor;
import replacecall.org.checkerframework.checker.initialization.qual.Initialized;
import replacecall.org.checkerframework.checker.interning.qual.Interned;
import replacecall.org.checkerframework.checker.interning.qual.UnknownInterned;
import replacecall.org.checkerframework.checker.nullness.qual.NonNull;
import replacecall.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import replacecall.org.checkerframework.checker.signature.qual.SignatureUnknown;

public abstract class Annotations
extends Attribute {
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown AnnotationEntry @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] annotationTable;
    private final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean isRuntimeVisible;

    Annotations(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte annotation_type, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int length, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataInput input, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean isRuntimeVisible) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        this(annotation_type, name_index, length, (AnnotationEntry[])null, constant_pool, isRuntimeVisible);
        int annotation_table_length = input.readUnsignedShort();
        this.annotationTable = new AnnotationEntry[annotation_table_length];
        for (int i = 0; i < annotation_table_length; ++i) {
            this.annotationTable[i] = AnnotationEntry.read(input, constant_pool, isRuntimeVisible);
        }
    }

    public Annotations(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte annotationType, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int nameIndex, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int length, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown AnnotationEntry @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] annotationTable, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constantPool, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean isRuntimeVisible) {
        super(annotationType, nameIndex, length, constantPool);
        this.annotationTable = annotationTable;
        this.isRuntimeVisible = isRuntimeVisible;
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Visitor v) {
        v.visitAnnotation(this);
    }

    public final void setAnnotationTable(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown AnnotationEntry @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] annotationTable) {
        this.annotationTable = annotationTable;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown AnnotationEntry @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getAnnotationEntries() {
        return this.annotationTable;
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getNumAnnotations() {
        if (this.annotationTable == null) {
            return 0;
        }
        return this.annotationTable.length;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean isRuntimeVisible() {
        return this.isRuntimeVisible;
    }

    protected void writeAnnotations(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream dos) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        if (this.annotationTable == null) {
            return;
        }
        dos.writeShort(this.annotationTable.length);
        for (AnnotationEntry element : this.annotationTable) {
            element.dump(dos);
        }
    }
}

