/*
 * Decompiled with CFR 0.152.
 */
package randoop.instrument;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.instrument.IllegalClassFormatException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.plumelib.reflection.Signatures;
import org.plumelib.util.EntryReader;
import randoop.instrument.MethodSignature;
import randoop.instrument.ReplaceCallAgent;
import randoop.instrument.ReplacementFileException;
import replacecall.org.apache.bcel.classfile.ClassParser;
import replacecall.org.apache.bcel.classfile.JavaClass;
import replacecall.org.apache.bcel.classfile.Method;
import replacecall.org.apache.bcel.generic.ObjectType;
import replacecall.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import replacecall.org.checkerframework.checker.mustcall.qual.MustCall;
import replacecall.org.checkerframework.checker.mustcall.qual.Owning;
import replacecall.org.checkerframework.checker.nullness.qual.Nullable;
import replacecall.org.checkerframework.checker.regex.qual.Regex;
import replacecall.org.checkerframework.checker.regex.qual.UnknownRegex;
import replacecall.org.checkerframework.checker.signature.qual.BinaryName;
import replacecall.org.checkerframework.checker.signature.qual.DotSeparatedIdentifiers;
import replacecall.org.checkerframework.checker.signature.qual.SignatureUnknown;
import replacecall.org.checkerframework.checker.signedness.qual.Signed;
import replacecall.org.checkerframework.common.value.qual.UnknownVal;

public class ReplacementFileReader {
    public static final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String ID_STRING = "\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*";
    public static final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String DOT_DELIMITED_IDS = "\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*(?:\\.\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)*";
    private static final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String SIGNATURE_STRING = "\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*(?:\\.\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)*(?:\\.<init>)?\\([^)]*\\)";
    private static final @Regex(value=2) @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Pattern SIGNATURE_LINE = Pattern.compile("(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*(?:\\.\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)*(?:\\.<init>)?\\([^)]*\\))[ \\t]+(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*(?:\\.\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)*(?:\\.<init>)?\\([^)]*\\))");
    private static final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Pattern PACKAGE_OR_CLASS_LINE = Pattern.compile("(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*(?:\\.\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)*)[ \\t]+(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*(?:\\.\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)*)");
    private static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Map<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown JavaClass> javaClasses = new ConcurrentHashMap<String, JavaClass>();

    static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Map<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown MethodSignature, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown MethodSignature> readReplacements(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Path replacementFile) throws @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown IOException, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReplacementFileException {
        try (BufferedReader replacementReader = Files.newBufferedReader(replacementFile, StandardCharsets.UTF_8);){
            Map<MethodSignature, MethodSignature> map = ReplacementFileReader.readReplacements(replacementReader, replacementFile.toString());
            return map;
        }
    }

    static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Map<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown MethodSignature, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown MethodSignature> readReplacements(@Owning @UnknownRegex @MustCall(value={"close"}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Reader in, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String filename) throws @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReplacementFileException, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown IOException {
        HashMap<MethodSignature, MethodSignature> replacementMap = new HashMap<MethodSignature, MethodSignature>();
        try (EntryReader reader = new EntryReader(in, filename, "//.*$", null);){
            for (String line : reader) {
                String trimmed = line.trim();
                if (trimmed.isEmpty()) continue;
                Matcher signatureLineMatcher = SIGNATURE_LINE.matcher(line);
                if (signatureLineMatcher.matches()) {
                    try {
                        ReplacementFileReader.addMethodReplacement(replacementMap, signatureLineMatcher.group(1), signatureLineMatcher.group(2));
                        continue;
                    }
                    catch (ClassNotFoundException | NoSuchMethodException | IllegalClassFormatException | ReplacementException e) {
                        throw new ReplacementFileException(e.getMessage(), filename, reader.getLineNumber(), line);
                    }
                }
                Matcher packageOrClassLineMatcher = PACKAGE_OR_CLASS_LINE.matcher(line);
                if (packageOrClassLineMatcher.matches()) {
                    try {
                        @DotSeparatedIdentifiers String original = packageOrClassLineMatcher.group(1);
                        @DotSeparatedIdentifiers String replacement = packageOrClassLineMatcher.group(2);
                        ReplacementFileReader.addReplacementsForClassOrPackage(replacementMap, original, replacement);
                        continue;
                    }
                    catch (IOException | ClassNotFoundException | NoClassDefFoundError | ReplacementException e) {
                        throw new ReplacementFileException(e.getMessage(), filename, reader.getLineNumber(), line);
                    }
                }
                String msg = "Error in replacement file: bad format";
                throw new ReplacementFileException(msg, filename, reader.getLineNumber(), line);
            }
        }
        return replacementMap;
    }

    private static void addMethodReplacement(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Map<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown MethodSignature, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown MethodSignature> replacementMap, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String originalSignature, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String replacementSignature) throws @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReplacementException, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassNotFoundException, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown IllegalClassFormatException, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown NoSuchMethodException {
        MethodSignature replacement;
        MethodSignature original;
        try {
            original = MethodSignature.of(originalSignature);
        }
        catch (IllegalArgumentException e) {
            throw new ReplacementException("Bad original signature", e);
        }
        original.toMethod();
        try {
            replacement = MethodSignature.of(replacementSignature);
        }
        catch (IllegalArgumentException e) {
            throw new ReplacementException("Bad replacement signature", e);
        }
        replacement.toMethod();
        ReplacementFileReader.addReplacement(replacementMap, original, replacement);
    }

    private static void addReplacement(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Map<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown MethodSignature, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown MethodSignature> replacementMap, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown MethodSignature original, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown MethodSignature replacement) throws @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReplacementException {
        if (replacementMap.get(original) != null) {
            String msg = String.format("Method %s already has replacement %s, trying to add another %s", original, replacementMap.get(original), replacement);
            throw new ReplacementException(msg);
        }
        replacementMap.put(original, replacement);
    }

    private static void addReplacementsForClassOrPackage(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Map<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown MethodSignature, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown MethodSignature> replacementMap, @DotSeparatedIdentifiers @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed String original, @DotSeparatedIdentifiers @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed String replacement) throws @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReplacementException, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown IOException, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassNotFoundException {
        String replacementClassPath = replacement.replace('.', '/') + ".class";
        URL resource = ClassLoader.getSystemResource(replacementClassPath);
        if (resource != null) {
            ReplacementFileReader.addReplacementsForClass(replacementMap, original, replacement);
        } else {
            ReplacementFileReader.addReplacementsForPackage(replacementMap, original, replacement);
        }
    }

    private static void addReplacementsForClass(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Map<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown MethodSignature, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown MethodSignature> replacementMap, @DotSeparatedIdentifiers @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed String originalPackage, @DotSeparatedIdentifiers @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed String replacementPackage, @BinaryName @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed String classname) throws @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassNotFoundException, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReplacementException {
        ReplacementFileReader.addReplacementsForClass(replacementMap, Signatures.addPackage(originalPackage, classname), Signatures.addPackage(replacementPackage, classname));
    }

    private static void addReplacementsForClass(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Map<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown MethodSignature, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown MethodSignature> replacementMap, @BinaryName @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed String originalClassname, @BinaryName @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed String replacementClassname) throws @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassNotFoundException, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReplacementException {
        JavaClass replacementJC = ReplacementFileReader.getJavaClassFromClassname(replacementClassname);
        if (replacementJC == null) {
            throw new ReplacementException("Replacement class not found: " + replacementClassname);
        }
        for (Method m4 : replacementJC.getMethods()) {
            if (m4.getName().equals("<init>") || m4.isPrivate()) continue;
            if (!m4.isStatic()) {
                String msg = String.format("Non-static non-private replacement method found: %s.%s", replacementClassname, m4.getName());
                throw new ReplacementException(msg);
            }
            MethodSignature replacement = MethodSignature.of(replacementClassname, m4);
            MethodSignature original = replacement.substituteClassname(originalClassname);
            if (original.exists()) {
                ReplacementFileReader.addReplacement(replacementMap, original, replacement);
                continue;
            }
            if (replacement.getParameterTypes().length > 0 && replacement.getParameterTypes()[0].equals(new ObjectType(originalClassname)) && (original = original.removeFirstParameter()).exists()) {
                ReplacementFileReader.addReplacement(replacementMap, original, replacement);
                continue;
            }
            String msg = String.format("Replacement method %s has no matching original in %s%n", replacement, originalClassname);
            throw new ReplacementException(msg);
        }
    }

    private static void addReplacementsForPackage(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Map<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown MethodSignature, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown MethodSignature> replacementMap, @DotSeparatedIdentifiers @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed String originalPackage, @DotSeparatedIdentifiers @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed String replacementPackage) throws @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReplacementException, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassNotFoundException {
        String replacementPackagePath;
        URL url;
        if (ReplaceCallAgent.debug) {
            System.err.println("javaVersion: " + System.getProperty("java.version"));
            System.err.println("javaHome: " + System.getProperty("java.home"));
            System.err.println("bootclasspath: " + System.getProperty("sun.boot.class.path"));
            System.err.println("classpath: " + System.getProperty("java.class.path"));
        }
        if ((url = ClassLoader.getSystemResource(replacementPackagePath = replacementPackage.replace('.', '/'))) == null) {
            String msg = String.format("No package for replacement %s found on classpath", replacementPackage);
            throw new ReplacementException(msg);
        }
        String protocol = url.getProtocol();
        if (protocol.equals("jar")) {
            String jarFilePath = ReplaceCallAgent.getJarPathFromURL(url);
            Path file = Paths.get(jarFilePath, new String[0]);
            try (JarFile jarFile = new JarFile(file.toFile());){
                ReplacementFileReader.addReplacementsFromAllClassesOfPackage(replacementMap, originalPackage, replacementPackage, jarFile);
                return;
            }
            catch (IOException e) {
                throw new ReplacementException("Error reading jar file " + file, e);
            }
        }
        if (protocol.equals("file")) {
            Path path = null;
            try {
                path = Paths.get(URLDecoder.decode(url.getPath(), "UTF-8"), new String[0]);
            }
            catch (Exception e) {
                throw new ReplacementException("Unable to extract Path from URL: " + url, e);
            }
            if (Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0])) {
                ReplacementFileReader.addReplacementsForPackage(replacementMap, originalPackage, replacementPackage, path);
                return;
            }
        } else {
            throw new ReplacementException("URL protocol not 'file' or 'jar'");
        }
    }

    private static void addReplacementsForPackage(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Map<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown MethodSignature, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown MethodSignature> replacementMap, @DotSeparatedIdentifiers @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed String originalPackage, @DotSeparatedIdentifiers @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed String replacementPackage, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Path replacementDirectory) throws @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReplacementException, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassNotFoundException {
        File[] files = replacementDirectory.toFile().listFiles();
        if (files == null) {
            throw new Error("Not a directory: " + replacementDirectory);
        }
        for (File file : files) {
            String filename = file.getName();
            if (file.isFile()) {
                if (!filename.endsWith(".class")) continue;
                ReplacementFileReader.addReplacementsForClass(replacementMap, originalPackage, replacementPackage, Signatures.classfilenameToBaseName(filename));
                continue;
            }
            if (!file.isDirectory()) continue;
            @DotSeparatedIdentifiers String originalPackageRecurse = originalPackage + "." + filename;
            @DotSeparatedIdentifiers String replacementPackageRecurse = replacementPackage + "." + filename;
            ReplacementFileReader.addReplacementsForPackage(replacementMap, originalPackageRecurse, replacementPackageRecurse, file.toPath());
        }
    }

    private static void addReplacementsFromAllClassesOfPackage(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Map<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown MethodSignature, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown MethodSignature> replacementMap, @DotSeparatedIdentifiers @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed String originalPackage, @DotSeparatedIdentifiers @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed String replacementPackage, @UnknownRegex @MustCall(value={"close"}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown JarFile jarFile) throws @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReplacementException, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassNotFoundException {
        String replacementPath = replacementPackage.replace('.', '/') + "/";
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String filename = entry.getName();
            if (!filename.endsWith(".class") || !filename.startsWith(replacementPath)) continue;
            ReplacementFileReader.addReplacementsForClass(replacementMap, originalPackage, replacementPackage, Signatures.classfilenameToBaseName(filename));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static @Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown JavaClass getJavaClassFromClassname(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String classname) throws @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReplacementException {
        JavaClass c = javaClasses.get(classname);
        if (c != null) {
            return c;
        }
        String classFilename = classname.replace('.', '/') + ".class";
        try (InputStream is = ClassLoader.getSystemResourceAsStream(classFilename);){
            if (is == null) {
                JavaClass javaClass = null;
                return javaClass;
            }
            ClassParser parser = new ClassParser(is, classname);
            c = parser.parse();
            javaClasses.put(classname, c);
            JavaClass javaClass = c;
            return javaClass;
        }
        catch (Exception e) {
            if (!ReplaceCallAgent.debug) throw new ReplacementException("Error reading class file: " + classFilename, e);
            System.out.println("Problem in getJavaClassFromClassname:");
            e.printStackTrace(System.out);
            throw new ReplacementException("Error reading class file: " + classFilename, e);
        }
    }

    private static class ReplacementException
    extends Throwable {
        ReplacementException(@Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String message) {
            super(message);
        }

        ReplacementException(@Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String message, @Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Throwable cause) {
            super(message, cause);
        }
    }
}

