/*
 * Decompiled with CFR 0.152.
 */
package randoop.instrument;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.nio.file.Path;
import java.security.ProtectionDomain;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.Set;
import org.plumelib.bcelutil.BcelUtil;
import org.plumelib.bcelutil.InstructionListUtils;
import org.plumelib.bcelutil.SimpleLog;
import randoop.instrument.MethodSignature;
import randoop.instrument.ReplaceCallAgent;
import replacecall.org.apache.bcel.classfile.ClassParser;
import replacecall.org.apache.bcel.classfile.JavaClass;
import replacecall.org.apache.bcel.classfile.Method;
import replacecall.org.apache.bcel.generic.CPInstruction;
import replacecall.org.apache.bcel.generic.ClassGen;
import replacecall.org.apache.bcel.generic.Instruction;
import replacecall.org.apache.bcel.generic.InstructionFactory;
import replacecall.org.apache.bcel.generic.InstructionHandle;
import replacecall.org.apache.bcel.generic.InstructionList;
import replacecall.org.apache.bcel.generic.InvokeInstruction;
import replacecall.org.apache.bcel.generic.MethodGen;
import replacecall.org.apache.bcel.generic.NEW;
import replacecall.org.apache.bcel.generic.ReferenceType;
import replacecall.org.apache.bcel.generic.Type;
import replacecall.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import replacecall.org.checkerframework.checker.calledmethods.qual.CalledMethodsBottom;
import replacecall.org.checkerframework.checker.mustcall.qual.MustCall;
import replacecall.org.checkerframework.checker.nullness.qual.Nullable;
import replacecall.org.checkerframework.checker.regex.qual.RegexBottom;
import replacecall.org.checkerframework.checker.regex.qual.UnknownRegex;
import replacecall.org.checkerframework.checker.signature.qual.SignatureBottom;
import replacecall.org.checkerframework.checker.signature.qual.SignatureUnknown;
import replacecall.org.checkerframework.checker.signedness.qual.Signed;
import replacecall.org.checkerframework.checker.signedness.qual.SignednessBottom;
import replacecall.org.checkerframework.checker.signedness.qual.UnknownSignedness;
import replacecall.org.checkerframework.common.value.qual.BottomVal;
import replacecall.org.checkerframework.common.value.qual.UnknownVal;

public class CallReplacementTransformer
extends InstructionListUtils
implements ClassFileTransformer {
    private static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown SimpleLog debug_transform = new SimpleLog(ReplaceCallAgent.debugPath + File.separator + "replacecall-transform-log.txt", ReplaceCallAgent.debug);
    private static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown SimpleLog debug_map = new SimpleLog(ReplaceCallAgent.debugPath + File.separator + "replacecall-method_mapping.txt", ReplaceCallAgent.debug);
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Map<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown MethodSignature, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown MethodSignature> replacementMap;
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String> excludedPackagePrefixes;
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Deque<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown NewInstInfo> new_inst_stack = new ArrayDeque<NewInstInfo>();

    CallReplacementTransformer(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Map<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown MethodSignature, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown MethodSignature> replacementMap, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String> excludedPackagePrefixes) {
        this.replacementMap = replacementMap;
        this.excludedPackagePrefixes = excludedPackagePrefixes;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown byte @Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown [] transform(@Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassLoader loader, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String className, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Class<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> classBeingRedefined, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ProtectionDomain protectionDomain, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown byte @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown [] classfileBuffer) throws @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown IllegalClassFormatException {
        JavaClass c;
        debug_transform.log("loader: %s, className: %s%n", loader, className);
        if (className == null) {
            return null;
        }
        String fullClassName = className.replace("/", ".");
        if (this.isExcludedClass(loader, fullClassName)) {
            debug_transform.log("transform: ignoring excluded class %s%n", className);
            return null;
        }
        debug_transform.log("%ntransform class: ENTER %s%n", className);
        try {
            ClassParser parser = new ClassParser(new ByteArrayInputStream(classfileBuffer), className);
            c = parser.parse();
        }
        catch (Exception e) {
            debug_transform.log("transform class: EXIT parse of %s resulted in error %s%n", className, e);
            System.out.format("Unexpected exception %s (%s) in ClassParser.parse(%s)%n", e, e.getCause(), className);
            e.printStackTrace(System.out);
            return null;
        }
        try {
            ClassGen cg = new ClassGen(c);
            if (this.transformClass(cg)) {
                JavaClass javaClass = cg.getJavaClass();
                if (ReplaceCallAgent.debug) {
                    Path filepath = ReplaceCallAgent.debugPath.resolve(className + ".class");
                    javaClass.dump(filepath.toFile());
                }
                debug_transform.log("transform class: EXIT %s transformed%n", className);
                return javaClass.getBytes();
            }
            debug_transform.log("transform class: EXIT %s not transformed (nothing to replace)%n", className);
            return null;
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (IllegalClassFormatException e) {
            debug_transform.log("transform class: EXIT transform of %s resulted in exception %s%n", className, e);
            System.out.format("Unexpected exception %s (cause=%s) in CallReplacementTransformer.transform(%s)%n", e, e.getCause(), className);
            throw e;
        }
        catch (Throwable e) {
            debug_transform.log("transform class: EXIT transform of %s resulted in exception %s%n", className, e);
            System.out.format("Unexpected exception %s (%s) in CallReplacementTransformer.transform(%s)%n", e, e.getCause(), className);
            e.printStackTrace(System.out);
            return null;
        }
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isBootloadedClass(@Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassLoader loader) {
        return loader == null || loader.getParent() == null;
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isGUIClass(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String fullClassName) {
        return fullClassName.startsWith("java.awt.") || fullClassName.startsWith("javax.swing.");
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isExcludedClass(@Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassLoader loader, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String fullClassName) {
        if (this.isBootloadedClass(loader) && !this.isGUIClass(fullClassName)) {
            return true;
        }
        if (fullClassName.contains("ByMockito")) {
            return true;
        }
        for (String prefix : this.excludedPackagePrefixes) {
            if (!fullClassName.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean transformClass(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassGen cg) throws @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown IllegalClassFormatException, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown IOException {
        boolean transformed = false;
        InstructionFactory ifact = new InstructionFactory(cg);
        boolean save_debug = this.debugInstrument.enabled;
        for (Method method : cg.getMethods()) {
            try {
                CallReplacementTransformer callReplacementTransformer = this;
                synchronized (callReplacementTransformer) {
                    this.new_inst_stack.clear();
                    this.pool = cg.getConstantPool();
                    MethodGen mg = new MethodGen(method, cg.getClassName(), this.pool);
                    debug_transform.log("%ntransform method: ENTER %s%n", mg.getName());
                    if ((0x1000 & mg.getAccessFlags()) > 0) {
                        continue;
                    }
                    InstructionList il = mg.getInstructionList();
                    if (il == null) {
                        continue;
                    }
                    this.debugInstrument.enabled = false;
                    this.setCurrentStackMapTable(mg, cg.getMajor());
                    this.buildUninitializedNewMap(il);
                    this.fixLocalVariableTable(mg);
                    this.debugInstrument.enabled = save_debug;
                    if (!this.transformMethod(cg, mg, ifact)) {
                        continue;
                    }
                    transformed = true;
                    this.updateUninitializedNewOffsets(il);
                    this.createNewStackMapAttribute(mg);
                    this.remove_local_variable_type_table(mg);
                    mg.setInstructionList(il);
                    mg.update();
                    mg.setMaxLocals();
                    mg.setMaxStack();
                    mg.update();
                    try {
                        cg.replaceMethod(method, mg.getMethod());
                    }
                    catch (Exception e) {
                        String msg = e.getMessage();
                        if (msg != null && msg.startsWith("Branch target offset too large")) {
                            System.out.printf("ReplaceCall warning: ClassFile: %s - method %s is too large to instrument and is being skipped.%n", cg.getClassName(), mg.getName());
                            continue;
                        }
                        throw e;
                    }
                    this.debugInstrument.log("%n%s.%s modified code: %s%n%n", mg.getClassName(), mg.getName(), mg.getMethod().getCode());
                    cg.update();
                }
            }
            catch (Exception e) {
                System.out.printf("Unexpected exception processing method %s%n", method.getName());
                this.debugInstrument.enabled = save_debug;
                throw e;
            }
        }
        return transformed;
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean transformMethod(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassGen cg, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown MethodGen mg, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown InstructionFactory ifact) throws @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown IllegalClassFormatException {
        InstructionList il = mg.getInstructionList();
        InstructionHandle ih = il.getStart();
        boolean transformed = false;
        while (ih != null) {
            InstructionHandle nextHandle = ih.getNext();
            InstructionList new_il = this.getReplacementInstruction(cg, mg, ifact, ih);
            if (new_il != null) {
                this.debugInstrument.log("%s.%s:%n", mg.getClassName(), mg.getName());
                transformed = true;
                this.replaceInstructions(mg, il, ih, new_il);
            }
            ih = nextHandle;
        }
        return transformed;
    }

    private @Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown InstructionList getReplacementInstruction(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassGen cg, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown MethodGen mg, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown InstructionFactory ifact, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown InstructionHandle ih) throws @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown IllegalClassFormatException {
        InvokeInstruction newInvocation;
        Instruction inst = ih.getInstruction();
        if (inst instanceof NEW) {
            String new_class = ((CPInstruction)ih.getInstruction()).getType(this.pool).toString();
            this.new_inst_stack.push(new NewInstInfo(ih, new_class));
            return null;
        }
        if (!(inst instanceof InvokeInstruction)) {
            return null;
        }
        InvokeInstruction origInvocation = (InvokeInstruction)inst;
        MethodSignature origSig = MethodSignature.of(origInvocation, this.pool);
        MethodSignature newSig = this.replacementMap.get(origSig);
        String super_class_name = cg.getSuperclassName();
        String class_name = cg.getClassName();
        String method_name = mg.getName();
        String invoke_class = origSig.getClassname();
        String invoke_method = origSig.getName();
        if (newSig == null) {
            debug_transform.log("%s.%s: No replacement for %s%n", class_name, method_name, origSig);
            if (invoke_method.equals("<init>")) {
                if (method_name.equals("<init>")) {
                    if (invoke_class.equals(class_name)) {
                        return null;
                    }
                    if (invoke_class.equals(super_class_name)) {
                        return null;
                    }
                }
                NewInstInfo top = this.new_inst_stack.pop();
                if (!invoke_class.equals(top.new_class)) {
                    throw new IllegalClassFormatException("Type of NEW object and <init> method do not match.");
                }
            }
            return null;
        }
        boolean new_dup_removed = false;
        if (invoke_method.equals("<init>")) {
            if (method_name.equals("<init>")) {
                if (invoke_class.equals(class_name)) {
                    debug_transform.log("%s.%s: Do not modify call to this().<init>%n", class_name, method_name);
                    return null;
                }
                if (invoke_class.equals(super_class_name)) {
                    debug_transform.log("%s.%s: Do not modify call to super().<init>%n", class_name, method_name);
                    return null;
                }
            }
            NewInstInfo top = this.new_inst_stack.pop();
            if (!invoke_class.equals(top.new_class)) {
                throw new IllegalClassFormatException("Type of NEW object and <init> method do not match.");
            }
            if (top.new_inst.getNext().getInstruction().getOpcode() != 89) {
                throw new IllegalClassFormatException("Unable to find NEW DUP pair.");
            }
            this.delete_instructions(mg, top.new_inst, top.new_inst.getNext());
            new_dup_removed = true;
        }
        debug_transform.log("%s.%s: Replacing method %s with %s%n", class_name, method_name, origSig, newSig);
        switch (origInvocation.getOpcode()) {
            case 182: 
            case 183: 
            case 185: {
                ReferenceType instanceType = origInvocation.getReferenceType(this.pool);
                if (new_dup_removed) {
                    newInvocation = ifact.createInvoke(newSig.getClassname(), newSig.getName(), instanceType, origInvocation.getArgumentTypes(this.pool), (short)184);
                    break;
                }
                Type[] arguments = BcelUtil.prependToArray(instanceType, origInvocation.getArgumentTypes(this.pool));
                newInvocation = ifact.createInvoke(newSig.getClassname(), newSig.getName(), origInvocation.getReturnType(this.pool), arguments, (short)184);
                break;
            }
            case 184: {
                newInvocation = ifact.createInvoke(newSig.getClassname(), newSig.getName(), origInvocation.getReturnType(this.pool), origInvocation.getArgumentTypes(this.pool), (short)184);
                break;
            }
            default: {
                debug_transform.log("getReplacementInstruction: EXIT Exception thrown due to wrong instruction type in %s.%s%n", mg.getClassName(), mg.getName());
                String msg = String.format("Unexpected invoke instruction %s in %s.%s", origInvocation, mg.getClassName(), mg.getName());
                throw new IllegalClassFormatException(msg);
            }
        }
        return this.build_il(newInvocation);
    }

    private void logReplacementMap() {
        if (debug_map.enabled()) {
            if (this.replacementMap.isEmpty()) {
                debug_map.log("No method replacements", new Object[0]);
            } else {
                debug_map.log("%nMethod replacement list:%n", new Object[0]);
                for (Map.Entry<MethodSignature, MethodSignature> entry : this.replacementMap.entrySet()) {
                    debug_map.log("%s => %s%n", entry.getKey(), entry.getValue());
                }
            }
        }
    }

    void addMapFileShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                CallReplacementTransformer.this.logReplacementMap();
            }
        });
    }

    private static class NewInstInfo {
        @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown InstructionHandle new_inst;
        @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String new_class;

        public NewInstInfo(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown InstructionHandle new_inst, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String new_class) {
            this.new_inst = new_inst;
            this.new_class = new_class;
        }
    }
}

