###
### charme.py
###
### cs150 
### Problem Set 7
###
### Charme originally written by David Evans
### Modified by Westley Weimer for CS 150
###
###
### Put any code you add at the bottom of the file. 

###
### Parser
###

authors = [ "mst3k", "abc1z" ]

def parseError(msg):
    print "Parse error: " + msg
    
def tokenize(s):
    current = ''
    tokens = []
    for c in s:
        if c.isspace():
            if len(current) > 0:
                tokens.append(current)
                current = ''
        elif c in '()':
            if len(current) > 0:
                tokens.append(current)
                current = ''
            tokens.append(c)
        else:
            current = current + c

    if len(current) > 0:
        tokens.append(current)
    return tokens

def parse(s):
    def parsetokens(tokens, inner):
       res = []
       while len(tokens) > 0:
          current = tokens.pop(0)
          if current == '(':
             res.append (parsetokens(tokens, True))
          elif current == ')':
             if inner:
                return res
             else:
                parseError("Unmatched close paren: " + s)
                return None
          else:
             res.append(current)
        
       if inner:
          parseError ("Unmatched open paren: " + s)
          return None
       else:
          return res

    return parsetokens(tokenize(s), False)

###
### Evaluator
###

def evalError(msg):
    print "Error: " + msg    
    
###
### Primitive Procedures
###
    
def checkOperands(operands, num, prim):
    if (len(operands) != num):
       print ("%s expected %s operands, given %s: %s"
              % (prim, num, len(operands), str(operands)))
           
def primitivePlus (operands):
    if (len(operands) == 0):
       return 0
    else:
       return operands[0] + primitivePlus (operands[1:])

def primitiveTimes (operands):
    if (len(operands) == 0):
       return 1
    else:
       return operands[0] * primitiveTimes (operands[1:])
    
def primitiveMinus (operands):
    if (len(operands) == 1):
       return -1 * operands[0]
    elif len(operands) == 2:
       return operands[0] - operands[1]
    else:
       evalError("Primitive - expected 1 or 2 operands, given %s: %s"
                  % (len(operands), str(operands)))

def primitiveEquals (operands):
    checkOperands (operands, 2, "=")
    return operands[0] == operands[1]

def primitiveZero (operands):
    checkOperands (operands, 1, "zero?")
    return operands[0] == 0

def primitiveGreater (operands):
    checkOperands (operands, 2, ">")
    return operands[0] > operands[1]

def primitiveLessThan (operands):
    checkOperands (operands, 2, "<")
    return operands[0] < operands[1]

###
### Primitives
###

def isNumber(expr):
    return isinstance(expr, str) and expr.isdigit()

def isPrimitiveProcedure(expr):
    return callable(expr)

def isPrimitive(expr):
    return (isNumber(expr) or isPrimitiveProcedure(expr))

def evalPrimitive(expr):
    # A primitive evaluates to its pre-defined value
    if isNumber(expr):
        return int(expr)
    else:
        return expr

###
### Conditionals
###
    
def isSpecialForm(expr, keyword):
    return isinstance(expr, list) \
           and len(expr) > 0 and expr[0] == keyword

def isConditional(expr):
    return isSpecialForm(expr, 'cond')

def evalConditional(expr, env):
    assert isConditional(expr)
    if len(expr) <= 2:
        evalError ("Bad conditional expression: %s" % str(expr))
    for clause in expr[1:]:
        if len(clause) != 2:
            evalError ("Bad conditional clause: %s" % str(clause))
        predicate = clause[0]
        result = meval(predicate, env)
        if not result == False:
            return meval(clause[1], env)
    evalError ("No conditional predicate evaluates to non-false value: %s"
               % (expr))
    return None

###
### Names and Definitions
###
    
class Environment:
    def __init__(self, parent):
        self._parent = parent
        self._frame = { }
    def addVariable(self, name, value):
        # add a new name, or replace old value
        self._frame[name] = value
    def lookupVariable(self, name):
        if self._frame.has_key(name):
            return self._frame[name]
        elif (self._parent):
            return self._parent.lookupVariable(name)
        else:
            evalError("Undefined name: %s" % (name))
    def toString(self):
        return "<Environment: %s / %s>" % (str(self._frame), str(self._parent))

def isDefinition(expr):
    return isSpecialForm(expr, 'define')

def evalDefinition(expr, env):
    assert isDefinition(expr)
    if len(expr) != 3:
        evalError ("Bad definition: %s" % str(expr))
    name = expr[1]
    if isinstance(name, str):
        value = meval(expr[2], env)
        env.addVariable(name, value)
    elif isinstance(name, list):
        evalError ("Procedure definition syntax not implemented")
    else:
        evalError ("Bad definition: %s" % str(expr))

def isName(expr):
    return isinstance(expr, str)

def evalName(expr, env):
    # To evaluate a name, lookup the value of the name in the environment
    assert isName(expr)
    return env.lookupVariable(expr)

###
### Procedures and Applications
###

class Procedure:
    def __init__(self, params, body, env):
        self._params = params
        self._body = body
        self._env = env
    def getParams(self):
        return self._params
    def getBody(self):
        return self._body
    def getEnvironment(self):
        return self._env        
    def toString(self):
        return "<Procedure %s / %s>" % (str(self._params), str(self._body))

def isLambda(expr):
    return isSpecialForm(expr, 'lambda')

def evalLambda(expr,env):
    assert isLambda(expr)
    if len(expr) != 3:
        evalError ("Bad lambda expression: %s" % str(expr))
    return Procedure(expr[1], expr[2], env)
                      
def isApplication(expr):
    # Applications are lists [proc, oper, oper]
    # Assumes expr is not a special form (must check special forms first)
    return isinstance(expr, list)
   
def evalApplication(expr, env):
    # To evaluate an application, evaluate all the subexpressions
    subexprs = expr
    subexprvals = map (lambda sexpr: meval(sexpr, env), subexprs)
    # then, apply the value of the first subexpression to the rest
    return mapply(subexprvals[0], subexprvals[1:])

def mapply(proc, operands):
    if (isPrimitiveProcedure(proc)):
        return proc(operands)
    elif isinstance(proc, Procedure):
            params = proc.getParams()
            newenv = Environment(proc.getEnvironment())
            if len(params) != len(operands):
                evalError ("Parameter length mismatch: %s given operands %s" \
                           % (proc.toString(), str(operands)))
            for i in range(0, len(params)):
                newenv.addVariable(params[i], operands[i])        
            return meval(proc.getBody(), newenv)        
    else:
        evalError("Application of non-procedure: %s" % (proc))

###
### Core Evaluator
###

def meval(expr, env):
    if isPrimitive(expr):
       return evalPrimitive(expr)
    elif isConditional(expr):
       return evalConditional(expr, env)
    elif isLambda(expr):
       return evalLambda(expr, env)
    elif isDefinition(expr):                
       evalDefinition(expr, env)
    elif isName(expr):
       return evalName(expr, env)
    elif isApplication(expr):
       return evalApplication(expr, env)
    else:
       evalError ("Unknown expression type: " + str(expr))

def initializeGlobalEnvironment():
    global globalEnvironment
    globalEnvironment = Environment(None)
    globalEnvironment.addVariable('#t', True)
    globalEnvironment.addVariable('#f', False)
    globalEnvironment.addVariable('+', primitivePlus)
    globalEnvironment.addVariable('-', primitiveMinus)
    globalEnvironment.addVariable('*', primitiveTimes)
    globalEnvironment.addVariable('=', primitiveEquals)
    globalEnvironment.addVariable('zero?', primitiveZero)
    globalEnvironment.addVariable('>', primitiveGreater)
    globalEnvironment.addVariable('<', primitiveLessThan)

initializeGlobalEnvironment();

def evalLoop():
    print "Welcome to Charme (the Snake Charmer's Language)"
    initializeGlobalEnvironment()
    while True:
        expr = raw_input("Charme> ")
        if expr == 'quit':
            break
        exprs = parse(expr)
        for expr in exprs:
            res = meval(expr, globalEnvironment)
            if isinstance(res, Procedure):
                print res.toString()
            elif res != None:
                print res

###
### Evaluates a top-level expression 
###
###   evalToplevelExp( parse("(+ 123 456)") ) 
### prints out 579
###

def evalToplevelExp(parsedExp):
    for expr in parsedExp:
        res = meval(expr, globalEnvironment)
        if isinstance(res, Procedure):
            print res.toString()
        elif res != None:
            print res

###
### Bottom of File
###

