;;;
;;; listprocs.ss
;;; UVA CS150 Fall 2007
;;;

;;; This file contains some useful procedures for lists.  We have seen
;;; most of these in class or in the book.

;;; get-nth evaluates to the nth element in the list
;;;  (where the first element is element 1)

(define (get-nth lst num)
  (assert (> num 0))
  (if (= num 1) (car lst)
      (get-nth (cdr lst) (- num 1))))

(define (find-element-number lst el)
  (if (null? lst)
      (error "Element not found: " el)
      (if (eq? (car lst) el)
	  1
	  (+ 1 (find-element-number (cdr lst) el)))))

(define (insertl f lst start)
  (if (null? lst) 
      start
      (f (car lst) (insertl f (cdr lst) start))))

(define (list-filter f lst)
  (insertl
   (lambda (el rest) (if (f el) (cons el rest) rest))
   lst
   null))

(define (qsort lst cf)
  (if (null? lst) 
      lst
      (append 
       (qsort (list-filter (lambda (el) (cf el (car lst))) (cdr lst))
		  cf)
       (list (car lst))
       (qsort (list-filter (lambda (el) (not (cf el (car lst)))) (cdr lst))
		  cf))))

(define (revintsto n)
  (if (= n 0) null
      (cons n (revintsto (- n 1)))))

(define (intsto n)
  (reverse (revintsto n)))
