;;;
;;; auction.scm
;;; UVA CS150 Fall 2007
;;; Problem Set 5
;;;

;;; Table of people who can bid on items
(define bidders (make-new-table (list 'name 'email)))

;;; Table of the items currently up for auction
(define items (make-new-table (list 'item-name 'description)))

;;; Table of all bids on
(define bids (make-new-table (list 'bidder-name 'item-name 'amount)))

;;; setup-tables puts some entries in the tables for testing
;;; (Note: all bidders are purely fictional.  Any resemblance to
;;;  actual rich alumni is purely coincidental.)

(define (setup-tables)
  (set! bidders (make-new-table (list 'name 'email)))
  (set! items (make-new-table (list 'item-name 'description)))
  (set! bids (make-new-table (list 'bidder-name 'item-name 'amount)))

  (add-bidder! "Tim Koogle" "tk@yahoo.com")
  (add-bidder! "Tina Fey" "tina@snl.com")
  (add-bidder! "Dave Matthews" "dave@dmb.com")
  (add-bidder! "Katie Couric" "katie@cbs.com")
  (add-bidder! "Tiki Barber" "tiki@nbc.com")

  (post-item! "SEAS"  "School of Engine and Apple Science")
  (post-item! "CLAS"  "School of (Liberal) Arts and Sciences")
  (post-item! "COMM"  "Philip Morris School of Commerce")
  (post-item! "CS150" "Customer Service From Aardvarks to Zebras")

  (insert-bid! "Tim Koogle"    "SEAS" 10000000)
  (insert-bid! "Dave Matthews" "CLAS"  2000000)
  (insert-bid! "Tiki Barber"   "COMM" 79000000)
  (insert-bid! "Katie Couric"  "CLAS" 37000000)

  )

(define (make-string-selector match)
  (lambda (fval) (string=? fval match)))

(define (get-bids item)
  (table-entries (table-select bids 'item-name (make-string-selector item))))
