//
//  Visual_modelV2e.h
//  SimpleCrowdingModel
//
//  Created by David Kieras on 3/13/18.
//  Copyright © 2018 University of Michigan. All rights reserved.
//

#ifndef VISUAL_MODEL_H
#define VISUAL_MODEL_H

//#include "EPICLib/Geometry.h"
#include "Geometry.h"
#include "Program_constants.h"
#include "Search_object.h"
#include <iosfwd>
#include <vector>
#include <array>
#include <string>

namespace GU = Geometry_Utilities;
using Search_objects_t = std::vector<Search_object> ;

// A Visual_model object is created for each trial; statistics are collected for that trial only
class Visual_model {
public:
    Visual_model(Condition_e cond_, Search_objects_t& search_objects_)
        : condition(cond_), search_objects(search_objects_)
        {initialize();}
    // the eye starts at the fixation point; call this for each subsequent eye move
    // returns time in ms for eye movement motor activity to be done
    double move_eye(Search_object& saccade_target_obj);
    
    GU::Point get_eye_location() const
        {return eye_location;}
	
	int get_n_fixations() const
		{return n_fixations;}
        
    // how many times a distractor has target perceptual properties
    int get_n_illusory_targets() const
        {return n_illusory_targets;}

    // how many times a target has distractor properties
    int get_n_target_illusory_distractors() const
        {return n_target_illusory_distractors;}

    // how many times a target has blank property when sensory known
    int get_n_target_illusory_blanks() const
        {return n_target_illusory_blanks;}
/*
    // how many times a target has distractor properties
    int get_n_target_sens_property_present() const
        {return n_target_sens_property_present;}

    // how many times a target has distractor properties
    int get_n_target_perc_property_present() const
        {return n_target_perc_property_present;}

    // how many times no object with target property is available (no actual or illusory target)
    int get_n_target_property_overwritten() const
        {return n_target_property_overwritten;}
*/
    static std::string get_id_string();

	
private:
    Search_objects_t& search_objects; // top level creates this container, referenced here
    Condition_e condition;
    GU::Point eye_location;
    // assumes Visual_model created for each trial, so these counters do not aggregate across trials
	int n_fixations = 0;
    // these counters are incremented by process_search_objects, initially and after each fixation
    int n_illusory_targets = 0; // counts how many times a distractor has target perceptual properties
    int n_target_illusory_distractors = 0; // counts how many times a target has distractor properties
	int n_target_illusory_blanks = 0; // counts how many times a target has a blank property when sensory property known
//	int n_target_sens_property_present = 0; // counts how many times an object has the target sensory property
//	int n_target_perc_property_present = 0;// counts how many times an object has the target perceptual property
//    int n_target_property_overwritten = 0;  // counts how many times target preceptual properties were available for a non-target object but the target does not have the target property
    
    // initialize the eye position and process the first set of objects
    void initialize();
    void process_search_objects();
    double make_saccade(GU::Point new_location);
    void update_sensory_properties();
    void find_crowders();
    void update_perceptual_properties();
    void update_Shape_information_gain();
    void update_Feature_information_gain();
    void scramble_perceptual_properties();
    void update_crowding_status();
    void scramble_perc_properties_by_permutation(Search_object& obj, char Search_object::*perc_prop_ptr);
    void scramble_perc_spat_configs_by_permutation(Search_object& obj);
    void recognize_shape(Search_object& obj, char Search_object::*from_ptr, Shape_parts_t Search_object::*to_ptr);
    void print_objects() const;

    void check_target_status(Condition_e condition, const Search_objects_t& search_objects);
    void check_CSF_target_status(const Search_objects_t& search_objects);
    void check_COC_target_status(const Search_objects_t& search_objects);
    void check_SHP_target_status(const Search_objects_t& search_objects);
};







#endif /* Visual_model_h */
