//
//  Search_object.h
//  
//
//  Created by David Kieras on 3/7/18.
//

#ifndef SEARCH_OBJECT_H
#define SEARCH_OBJECT_H

//#include "EPICLib/Geometry.h"
#include "Geometry.h"
#include "Program_constants.h"
#include <iosfwd>
#include <vector>
#include <array>
#include <map>

namespace GU = Geometry_Utilities;

struct Search_object {
    const char* name{"\0"}; // object type string, distractor vs target
    int ID{-1};    // physical object ID
    GU::Point location{};
    GU::Size size{};
    double eccentricity{-1};
    double nearest_neighbor_distance = -1; // distance to nearest neighbor
    double critical_spacing = -1.; // current critical spacing for finding crowding objects
    std::vector<int> crowder_group; // indices into search_objects of crowding objects; always includes this object
//    enum class Crowding_state_e {Unknown, Crowded, Uncrowded};
//    Crowding_state_e crowding_state = Crowding_state_e::Unknown;
	// below not used in Visual_modelV2d,e
    bool current_crowding = false; // true if this object either crowds, or is crowded by another object.
    bool known_perceptual_properties = false; // true if this object's properties have become known while uncrowded
    // below added circa 4/26/19 to go with VM2b
    double Shape_information_gain{0.0}; // the score for gain of information about shape if this object is fixated
    double Feature_information_gain{0.0}; // the score for gain of information about color and shape if this object is fixated

	// these are the true physical properties
	char phys_color{'.'};
    char phys_orientation{'.'};
    char phys_shape{'.'};

    bool is_target = false; // true if this is actually a target object - for ease in monitoring scrambling results

    // these are the sensory properties - change with eye movements
    char sens_color{'.'};
    char sens_orientation{'.'};
    char sens_shape{'.'};
 
    // these are the perceptual stored properties - subject to crowding, sticky past eye movements, but updated
    char perc_color{'.'};
    char perc_orientation{'.'};
    char perc_shape{'.'};
 
    Shape_parts_t sens_spat_config{spat_configNull};

   /* "seven segment" configuration
   arramge with horizontal first, top to bottom, then vertical top left,bottom left, top right, bottom right
        ---0---     target 2 is 0,1,2,b,4,5,b in numerical segment index order, 0,5,1,4,2 in stroke order
        |     |     distractor 5 is 0,1,2,3,b,b,6 in numerical segment index order, 0,3,1,6,2 in stroke order
        3     5
        |     |     0 - 6 are locations (i.e. centers of segments - left/center/right, top/middle/bottom, horizontal/vertical line segments
        |--1--|     both 2 and 5 have H top, middle, bottom, 2 also has V left top, V right bottom, 5 also has V right top, V left bottom
        |     |
        4     6     in array: 2: H,H,H,b,V,V,b  5: H,H,H,V,b,b,V
        |     |
         --2--
         assume line segments are .3 dva in thickness, characters are 1.5 X 2.7, so each segment is about .3 X 2.1 -> 1.2 dva avg size
    */
/*
    Shape_parts_t perc_spat_config{spat_configNull};    // "seven segment" spatial configuration:
    static constexpr Shape_parts_t spat_configNull = {'.','.','.','.','.','.','.'};
    static constexpr Shape_parts_t spat_config2 = {'H','H','H','b','V','V','b'};
    static constexpr Shape_parts_t spat_config5 = {'H','H','H','V','b','b','V'};
*/
    /* open/closed configuration
    open-left   open-right
    _            _      ]   [
    _|          |_      [   ]
 part[0] is top, part[1] is bottom
 Target 2 is open-left above open-right, distractor 5 is open-right above open-left
 */
    Shape_parts_t perc_spat_config{spat_configNull};    // open-right/left spatial configuration
    static constexpr Shape_parts_t spat_configNull = {'.','.'};
    static constexpr Shape_parts_t spat_config2 = {'L','R'}; 
    static constexpr Shape_parts_t spat_config5 = {'R','L'};
    static constexpr Shape_parts_t spat_configE = {'R','R'};
    static constexpr Shape_parts_t spat_config3 = {'L','L'};
    static constexpr Shape_parts_t spat_configct = {'R','.'};
    static constexpr Shape_parts_t spat_configcb = {'.','R'};
    static constexpr Shape_parts_t spat_configot = {'L','.'};
    static constexpr Shape_parts_t spat_configob = {'.','L'};

	static std::map<Shape_parts_t, char> parts_to_shape_map;



    // counter for generating unique ID numbers
    static int objectnum;

    // default ctor needed
    Search_object();
    // full constructor sets object name and location as supplied
    Search_object(const char * name, GU::Point location_, GU::Size size_,
        char color, char shape, char orientation, bool is_target = false);  // these are true physical properties
    // partial constructor allows later setting of object ID and location
    Search_object(const char * name, GU::Size size_, char color, char shape, char orientation, bool is_target = false);
    // set object ID
    void set_ID();
    // set object location
    void set_location(GU::Point location_);
    
    void print_sens_spat_config(std::ostream& os) const;
    void print_perc_spat_config(std::ostream& os) const;


};

// used throughout program
using Search_objects_t = std::vector<Search_object> ;

std::ostream& operator<< (std::ostream& os, const Search_object& so);

#endif /* SEARCH_OBJECT_H */

