//
//  Search_object.cpp
//  
//
//  Created by David Kieras on 3/7/18.
//

#include "Search_object.h"
#include "Program_constants.h"
//#include "EPICLib/Random_utilities.h"
#include "Random_utilities.h"
#include <iostream>

using namespace std;

// counter for object names
int Search_object::objectnum = 0;


std::map<Shape_parts_t, char> Search_object::parts_to_shape_map = {
		{spat_configNull, '.'},
		{spat_config2, '2'},
		{spat_config5, '5'},
		{spat_configE, 'E'},
		{spat_config3, '3'},
		{spat_configct, 'c'},
		{spat_configcb, 'c'},
		{spat_configot, 'o'},
		{spat_configob, 'o'}
		};


// default ctor
Search_object::Search_object() :
    ID(-1)
{
}

// full ctor
Search_object::Search_object(const char * name_, GU::Point location_, GU::Size size_, char color_, char shape_, char orientation_, bool is_target_) :
    name(name_), ID(++objectnum), size(size_), location(location_),
    phys_color(color_), phys_orientation(orientation_), phys_shape(shape_), is_target(is_target_),
    sens_color('.'), sens_orientation('.'), sens_shape('.'),
    perc_color('.'), perc_orientation('.'), perc_shape('.')
    {}
// partial ctor to allow setting ID and location later
Search_object::Search_object(const char * name_, GU::Size size_, char color_, char shape_, char orientation_, bool is_target_) :
    name(name_), size(size_),
    phys_color(color_), phys_orientation(orientation_), phys_shape(shape_), is_target(is_target_),
    sens_color('.'), sens_orientation('.'), sens_shape('.'),
    perc_color('.'), perc_orientation('.'), perc_shape('.')
    {}

void Search_object::set_ID()
{
    ID = ++objectnum;
}

void Search_object::set_location(GU::Point location_)
{
    location = location_;
}

void Search_object::print_sens_spat_config(ostream& os) const
{
    for(int i = 0; i < perc_spat_config.size(); i++)
        os << sens_spat_config[i];
}
void Search_object::print_perc_spat_config(ostream& os) const
{
    for(int i = 0; i < perc_spat_config.size(); i++)
        os << perc_spat_config[i];
}


ostream& operator<< (ostream& os, const Search_object& obj)
{
    os << obj.name << ' ' << obj.ID << ' ' << obj.location << ' ' << obj.eccentricity << ' ' << obj.size << ' '
        << obj.nearest_neighbor_distance << ' ';
        // output crowding status
    os << ((obj.current_crowding) ? 'c' : 'u') << ' '
        << ((obj.known_perceptual_properties) ? 'k' : ' ') << ' ';
    os << obj.phys_color << obj.phys_orientation << obj.phys_shape << " -> "
        << obj.sens_color << obj.sens_orientation << obj.sens_shape << ' ';
    obj.Search_object::print_sens_spat_config(os);
   //     os << " -> " << obj.perc_color << obj.perc_orientation << obj.perc_shape << ' ';
        os << " -> " << ((obj.known_perceptual_properties) ? "[" : "") << obj.perc_color << obj.perc_orientation << obj.perc_shape << ' ';
    obj.Search_object::print_perc_spat_config(os);
    	os << ((obj.known_perceptual_properties) ? "]" : "");
    // below added circa 4/26/19 to go with VM2b
    os << ' ';
    os << obj.Shape_information_gain << ' ';
    os << obj.Feature_information_gain;

    return os;
}


