//
//  PrdObsStatistics.hpp
//  SimpleCrowdingModel
//
//  Created by David Kieras on 4/17/18.
//  Copyright © 2018 University of Michigan. All rights reserved.
//

#ifndef PRDOBSSTATISTICS_H
#define PRDOBSSTATISTICS_H

#include "Program_constants.h"
#include "Statistics.h"
//#include "EPICLib/Statistics.h"

#include <iosfwd>

class PrdObsStatistics {
public:
    PrdObsStatistics();
    // read a file containing 3 X 8 RT values for CSF, COC, SHP, Each condition with values for Neg 3,6,12,18, Pos 3,5,12,18
    // followed by a 3 X 8 ER error rate values in the same order
    void load_obs_data(std::ifstream& infile, bool echo_print = true);

    void reset() {
        po_prop_errors.reset();
        po_rts.reset();
        }
    
    void update(Condition_e cond, Polarity_e polarity, int set_size, double pred_rt, double pred_err);

    void output(std::ostream& os) const;

private:
    double obsrts[3][2][4]; // condition X neg/pos X set size
    double obsproperrs[3][2][4]; // condition X neg/pos X set size
    
    PredObs_accumulator po_rts;
    PredObs_accumulator po_prop_errors;

    


};





#endif /* PRDOBSSTATISTICS_H */
