//
//  CrowdingSim.cpp
//  
//
//  Created by David Kieras on 3/7/18.
//

// as of 3/9/18, reproduced number of fixations produced by EPIC model of same date (used in ICCM2018Sub)

#include "Program_constants.h"
#include "Search_object.h"
//#include "Visual_modelV2b.h"
#include "Visual_modelV2e.h"
#include "Display_creator.h"
#include "Strategy.h"
#include "Trial_statistics.h"
#include "PrdObsStatistics.h"

/*#include "EPICLib/Symbol.h"
#include "EPICLib/Geometry.h"
#include "EPICLib/Statistics.h"
#include "EPICLib/Ostream_format_saver.h"
#include "EPICLib/Random_utilities.h"
#include "EPICLib/Symbol.h" */
#include "Geometry.h"
#include "Statistics.h"
#include "Ostream_format_saver.h"
#include "Random_utilities.h"

#include <iostream>
#include <fstream>
#include <sstream>
#include <iomanip>
#include <array>
#include <vector>
#include <algorithm>
#include <cassert>
#include <cfloat>
#include <limits>
#include <exception>


namespace GU = Geometry_Utilities;

using namespace std;

void do_grid_search();
void run_experiment();
void do_condition(Display_creator& display_creator, Condition_e cond, Polarity_e polarity, int set_size, int n_trials, PrdObsStatistics& prdobsstatistics);
//void do_trial(Display_creator& display_creator, Condition_e cond, int set_size, Polarity_e polarity, Statistics_accumulator& statistics);
//GU::Point move_eye(GU::Point current_eye_location, GU::Point obj_location);
//bool make_positive_response(Polarity_e polarity, Statistics_accumulator& statistics);
//bool make_negative_response(Polarity_e polarity, Statistics_accumulator& statistics);

const array<const char* const, 3> cond_labels{"CSF", "COC", "SHP"};
const array<const char* const, 2> pol_labels{"Neg", "Pos"};

// experiment mode runs conditions and writes predicted values and parameter+gof values to cout.
// grid-search mode runs conditions and writes experiment-mode output to a file and parameter+gof values to cout.

// try as global
//PrdObsStatistics prdobsstatistics;
ofstream output_file;

// following declared in Program_constants.h


//bool cout_experiment_results = true; // set to false for compact grid search results

int main()
{
    Ostream_format_saver format_save(cout);
    // Set output to show two decimal places for floating point numbers
//    cout << fixed << setprecision(2) << endl;
    cout.setf(ios::fixed, ios::floatfield);
    cout.precision(3);
    
/*    cout << "Normal cdf test mean = 0, sd = 1" << endl;
    for(double x = -6; x < 6.; x = x+1.0)
        cout << x << ' ' << normal_cdf(x, 0.0, 1.0) << endl;
 
    cout << "Normal cdf test for mean = 10, sd = 5" << endl;
    for(double x = -20; x < 20.; x = x+1.0)
        cout << x << ' ' << normal_cdf(x, 10., 5.0) << endl;
 */
/*    cout << "Gaussian detection probability test with a = 0, b = .5, sd = 0.5, size = GU::Size(3.5, 1.)" << endl;
    for (double ecc = 0.; ecc < 20.; ecc = ecc + 1)
        cout << ecc << ' ' << LinearConstSD_detection_probability(ecc, GU::Size(3.5, 1.), 0.0, 0.5, 0.5) << endl;
*/

//    cout << "_DECIMAL DIG: double precision: " << DBL_DECIMAL_DIG << " long double precision: " << LDBL_DECIMAL_DIG << endl;
//    cout << "sizeof double: " << sizeof(double) << " sizeof long double: " << sizeof(long double) << endl;
 /*   // load the desired data file
    ifstream infile(infile_name_c);
    if(!infile.good()) {
        cout << "Could not open observed data file \"" << infile_name_c << "\"!" << endl;
        return 1;
        }
    cout << "Observed data from " << infile_name_c << "\n";
    prdobsstatistics.load_obs_data(infile, false); // second parameter true means echo_print
*/
    cout << "Observed data from " << infile_name_c << "\n";
    cout << n_trials_c << " trials/condition" << endl;
    cout << Strategy::get_strategy_id_string();
    cout << Visual_model::get_id_string() << endl;
//    cout << ((apply_crowding_effect) ? "Crowding applied" : "No Crowding effect") << endl;

    try {
    switch(run_mode_c) {
        case Run_mode_e::EXPERIMENT:
            run_experiment();
            break;
        case Run_mode_e::GRID_SEARCH: {
            output_file.open("Outputfile.txt");
            if(!output_file.is_open())
                throw runtime_error("Could not open \"Outputfile.txt\"");
            do_grid_search();
            break;
            }
        default:
            assert(!"Invalid run_mode");
            break;
        }
/*    if(run_experiment_c)
        run_experiment();
    else
        do_grid_search();
*/
    }
    catch(exception& x) {
        cout << "Exception: " << x.what() << endl;
        }
}

const char* const model_output_headings_c = "\nCnd\t\tPol\tSS\tCN\tCRT\tEN\tERT\tER\tCMFix\tEMFix\tMITF\tMRptF\tMTgtF\tMNTID\tMNTIB\tMNIT";
const char* const parameter_metrics_heading_c =
    "C_av\tC_cp\tO_av\tO_cp\tS_av\tS_cs\tS_cp\tVDly\tPbER\tNbER\tMaxNfix\tCPskip\tCNskip\tMaxITF"
    "\tRT: Rsq\taae\taare\tFoM\tER: Rsq\taae\taare\tFoMa\tFoMr\tWAFoMs\tN";


void do_grid_search()
{
    cout << parameter_metrics_heading_c << endl;
    if(output_file.is_open())
        output_file << parameter_metrics_heading_c << endl;

//    cout << "C_av\tC_cp\tO_av\tO_cp\tS_av\tS_cs\tS_cp\tVDly\tPbER\tNbER\tMaxNfix\t";
//    cout << "RT: Rsq\taae\taare\tFoM\tER: Rsq\taae\taare\tFoMa\tFoMr\tWAFoMs\tN\n";
//    for(max_n_fixations_g = 2; max_n_fixations_g <= 3; max_n_fixations_g += 1) {
        for(color_slope_g = 0.0; color_slope_g <= 0.4; color_slope_g += 0.05) {
//            for(color_crowding_probability_g = .1; color_crowding_probability_g <= 0.8; color_crowding_probability_g += 0.1) {
//            for(orientation_slope_g = 0.05; orientation_slope_g <= 0.20; orientation_slope_g += 0.05) {
//            for(orientation_crowding_probability_g = .0; orientation_crowding_probability_g <= .1; orientation_crowding_probability_g += 0.05) {
 //                   for(shape_slope_g = .3; shape_slope_g <= .4; shape_slope_g += 0.025) {
 //                   for(shape_crowding_probability_g = 0.00; shape_crowding_probability_g <= .05; shape_crowding_probability_g += 0.005) {
                            run_experiment();
//                        } // shape_crowding_probability_g
//                        } // shape_slope_g
//                } //orientation_crowding_probability_g
//                } // orientation_slope_g
//            } // color_crowding_probability_g
            } // color_slope_g
//        } // max_n_fixations_g
}


void run_experiment()
{
    PrdObsStatistics prdobsstatistics;
    ifstream infile(infile_name_c);
    if(!infile.good()) {
        throw runtime_error("Could not open observed data file!");
//        cout << "Could not open observed data file \"" << infile_name_c << "\"!" << endl;
//        return 1;
        }
    prdobsstatistics.load_obs_data(infile, false); // second parameter true means echo_print
//    prdobsstatistics.reset();
    reset_random_number_generator_seed();
    Display_creator display_creator;

    if (run_mode_c == Run_mode_e::EXPERIMENT) {
        cout << model_output_headings_c << endl;
        }
    if(output_file.is_open()) {
        output_file << model_output_headings_c << endl;
        }


//    const auto conditions = {Condition_e::CSF, Condition_e::COC, Condition_e::SHP};
//    const auto conditions = {Condition_e::CSF, Condition_e::COC};
//    const auto conditions = {Condition_e::CSF};
//    const auto conditions = {Condition_e::COC};
//    const auto conditions = {Condition_e::SHP};

//    const auto polarities = {Polarity_e::NEGATIVE, Polarity_e::POSITIVE};
//    const auto polarities = {Polarity_e::POSITIVE};

//    const auto set_sizes = {3,6,12,18};
//    const auto set_sizes = {12};

    for(auto cond : conditions) {
        for(auto polarity : polarities) {
          for(int set_size : set_sizes) {
                do_condition(display_creator, cond, polarity, set_size, n_trials_c, prdobsstatistics);
                }
            }
        }

    ostringstream oss;
    oss << fixed << setprecision(3);
//    oss << parameter_metrics_heading_c << endl;
    oss << color_slope_g << "\t" << color_crowding_probability_g << "\t";
    oss << orientation_slope_g << "\t" << orientation_crowding_probability_g << "\t";
//    cout << shape_slope_g << "\t" << shape_crowding_probability_g << "\t";
    oss << shape_slope_g << "\t" << shape_crowding_slope_g << "\t" << shape_crowding_probability_g << "\t";
    oss << visual_delay_time_g << "\t";
    oss << setprecision(4) << positive_baseline_error_rate_c << "\t" << negative_baseline_error_rate_c << "\t";
    oss << setprecision(3);
    // if mixture probability > 0.0 AND max_n_fixations < 99, then use _g value,
    // otherwise calculate average value using mixture probability
    //
    if(max_n_fixations_mixture_probability_c > 0.0 && max_n_fixations_g < 99)
        oss << calculate_average_max_n_fixations() << "\t";
    else
        oss << max_n_fixations_g << "\t";;
    oss << close_enough_to_bypass_confirm_positive_c << "\t";
    oss << enough_fixations_to_bypass_confirm_negative_c << "\t";
    oss << too_many_illusory_targets_c << "\t";
    prdobsstatistics.output(oss);
    
     if (run_mode_c == Run_mode_e::EXPERIMENT) {
        cout << parameter_metrics_heading_c << endl;
        }
   // always output parameters and metrics
    cout << oss.str() << endl;
    if(output_file.is_open())
        output_file << oss.str() << endl;
}


void do_condition(Display_creator& display_creator, Condition_e cond, Polarity_e polarity, int set_size, int n_trials, PrdObsStatistics& prdobsstatistics)
{
    Trial_statistics statistics;
    Strategy strategy(display_creator, cond, set_size, polarity, statistics);
	
    display_creator.reset_display_statistics();
    
    // trial needs to be a global variable so that debugging output can include it
 
    for(trial_g = 0; trial_g < n_trials; trial_g++) {
        if(strategy_trace_output) cout << "\nTrial " << trial_g << endl;
        strategy.do_trial();
        }
    ostringstream oss;
    oss << fixed << setprecision(3);
    oss  << cond_labels[static_cast<int>(cond)] << "\t\t" << pol_labels[static_cast<int>(polarity)] << '\t' << set_size << '\t'
            << statistics.mean_RT.get_n() << '\t'
            << statistics.mean_RT.get_mean() << '\t'
            << statistics.mean_error_RT.get_n() << '\t'
            << statistics.mean_error_RT.get_mean() << '\t'
            << statistics.prop_errors.get_proportion() << '\t'
            << statistics.mean_n_fixations.get_mean() << '\t'
            << statistics.mean_error_n_fixations.get_mean() << '\t'
            << statistics.mean_illusory_target_fixations.get_mean() << '\t'
            << statistics.mean_repeat_fixations.get_mean() << '\t'
            << statistics.mean_target_fixations.get_mean() << '\t'
            << statistics.mean_n_target_illusory_distractor.get_mean() << '\t'
            << statistics.mean_n_target_illusory_blank.get_mean() << '\t'
            << statistics.mean_n_illusory_targets.get_mean()
//            << statistics.mean_n_target_sens_property_present.get_mean() << '\t'
//            << statistics.mean_n_target_perc_property_present.get_mean() << '\t'
//            << statistics.mean_n_target_property_overwritten.get_mean()
            ;

    if (run_mode_c == Run_mode_e::EXPERIMENT) {
        cout << oss.str() << endl;
/*    	cout << cond_labels[static_cast<int>(cond)] << "\t\t" << pol_labels[static_cast<int>(polarity)] << '\t' << set_size << '\t'
        << statistics.mean_RT.get_n() << '\t'
        << statistics.mean_RT.get_mean() << '\t'
        << statistics.prop_errors.get_proportion() << '\t'
        << statistics.mean_n_fixations.get_mean() << '\t'
        << statistics.mean_illusory_target_fixations.get_mean() << endl;
*/
        }
    if(output_file.is_open()) {
        output_file << oss.str() << endl;
        }
    if(compute_and_output_display_statistics)
        display_creator.output_display_statistics();

    prdobsstatistics.update(cond, polarity, set_size, statistics.mean_RT.get_mean(),statistics.prop_errors.get_proportion());
}


