/*
*	sys,dynlib,proto.h
*	required prototypes for dynamic library forward / backprojectors
*
*	Copyright 2003-6-14	Jeff Fessler	The University of Michigan
*/

typedef int bool;
typedef unsigned char byte;
typedef const int cint;

#include "def,subset.h"

extern bool sys_init(
const void *DoNotTouch1,
const char *userinfo,
const int n1,		/* measurement data dimensions */
const int n2,
const int n3,
const int nx,		/* object dimensions */
const int ny,
const int nz,
const int nz_raw,	/* = nz unless user asks for only some slices */
const int chat);	/* 0 for silent, >0 for diagnostics */

extern bool sys_free(const void *DoNotTouch);


/*
*	forward projector
*/
extern bool sys_proj(
const void *DoNotTouch,
float		*proj,	/* [n1,n2,n3] put projections of image here */
const float	*image,	/* [nx,ny,nz] image volume	*/
const byte	*mask,	/* [nx,ny,nz] binary support mask */
const Subsets	*ss,	/* subset control structure	*/
const int	chat);	/* 0 for silent, >0 for diagnostics */


/*
*	back projector
*/
extern bool sys_back(
const void *DoNotTouch,
float		*back,	/* [nx,ny,nz] backproject into this	*/
const float	*data,	/* [n1,n2,n3] data to backproject	*/
const float	*wi,	/* [n1,n2,n3] weights		*/
const Subsets	*ss,	/* subset control structure	*/
const int	chat);	/* 0 for silent, >0 for diagnostics */



/*
*	prototypes for ASPIRE projection / backprojection routines
*/

typedef void Sys;		/* not going to document the internals! */

/*
*	fi_read()
*	read in and initialize aspire system model
*/
extern Sys *fi_read(
const char	*sys_type,	/* string describing system, e.g. 2z@... */
const char	*file_mask,	/* filename for mask */
const byte	*mask,		/* [nx,ny,nz] */
		/* only one of mask or file_mask should be non-null */
const int	nx,		/* object size */
const int	ny,
const int	zmin,		/* 0 */
const int	zmax,		/* nz-1 */
const int	nz_raw,		/* nz */
const int	nthread,	/* 1, unless you have multiple processors... */
const int	chat);		/* verbosity */


/*
*	fi_free()
*	free an aspire system model
*/
extern bool fi_free(Sys *sys);


/*
*	fi_proj()
*	forward projector
*/
extern bool fi_proj(
float		*y,		/* [n1,n2,n3]	*/
const float	*x,		/* [nx,ny,nz]	*/
const Sys	*sys,
cSubsets	*ss,		/* subset control; NULL defaults to all views */
const int	chat);


/*
*	fi_back()
*	weighted backprojector:
*	back = G' * data		if wi = NULL
*	back = G' * D(wi) * data	if wi non-NULL
*/
bool fi_back(
float		*back,
const float	*data,		/* [[nd]] */
const Sys	*sys,
const float	*wi,		/* [[nd]] optional weights, used if non-NULL */
cSubsets	*ss,		/* subset control; NULL defaults to all views */
const int	chat);
