/*
*	spect,example.c
*
*	Example of user-defined 3d system model.
*	This is built on top of the existing 3s SPECT system model!
*	It uses the existing ASPIRE routines fi_read, fi_free, fi_proj, fi_back.
*
*	You are free to modify as long as you change the file name.
*	And it would be polite to keep my name attached.
*
*	See the documentation for compilation instructions.
*
*	Copyright 2003-7-10	Jeff Fessler	The University of Michigan
*/
#include <stdio.h>
#include <stdlib.h>
/*
#include "def.h"
*/
#include "sys,dynlib,proto.h"

#ifndef Fail
extern bool io_write_n(const char *, const void *, const char *, const double,
	const int *, const int, int, const char *, const char *, const char *,
	const bool, const int);

#define Fail(arg)	{ fprintf(stderr, arg "\n"); return 0; }
#define Iwrite3float(file, data, nx, ny, nz)	\
	{ int Idims[3]; Idims[0]=nx; Idims[1]=ny; Idims[2]=nz;	\
	if (!io_write_n(file, data, "float", 1., Idims, 3,	\
	                        0, NULL, NULL, "name", 1, 1)) \
		Fail("write") \
	}
#endif

/*
*	"global" (to this file) static variables
*/
static int nx_global=-1, ny_global=-1, nz_global=-1;
static int n1_global=-1, n2_global=-1, n3_global=-1;
static Sys *sys;	/* pointer to aspire system structure */


/*
*	sys_init()
*	Initialize any static local variables,
*	possibly using parameters extracted from :userinfo
*/
bool sys_init(
const void *DoNotTouch,
const char *userinfo,	/* for this example, it is "3s@..." */
const int n1,		/* measurement data dimensions */
const int n2,
const int n3,
const int nx,		/* object dimensions */
const int ny,
const int nz,
const int nz_raw,	/* = nz */
const int chat)
{
	const int nthread = 1;

	(void) DoNotTouch;

	nx_global = nx;
	ny_global = ny;
	nz_global = nz;
	n1_global = n1;
	n2_global = n2;
	n3_global = n3;

	if (chat)
		printf("userinfo = '%s'\n", userinfo);

	if (nz_raw != nz)	Fail("slice selection not implemented")

	sys = fi_read(userinfo, NULL, NULL, nx, ny, 0, nz-1, nz, nthread, chat);
	if (!sys)
		Fail("read failed")

	/*
	*	here is where you would parse the userinfo string further
	*	(if not earlier) and read in your own stuff
	*/

	return 1;
}


/*
*	sys_free()
*	Free any local memory that was allocated
*/
bool sys_free(const void *DoNotTouch)
{
	(void) DoNotTouch;

	if (!fi_free(sys))
		Fail("problem freeing")

	/*
	*	free your own stuff here
	*/

	return 1;
}


/*
*	sys_proj()
*	forward projector
*/
extern bool sys_proj(
const void *DoNotTouch,
float		*proj,	/* [n1,n2,n3] put projections of image here */
const float	*image,	/* [nx,ny,nz] image volume	*/
const byte	*mask,	/* [nx,ny,nz] binary support mask */
const Subsets	*ss,	/* subset control structure	*/
const int	chat)	/* 0 for silent, >0 for diagnostics */
{
	char command[512];
	int	status;
	(void) DoNotTouch;
	(void) mask;

	if (chat)
		printf("in sys_proj\n");

	if (!fi_proj(proj, image, sys, ss, chat))
		Fail("fi_proj")

	/*
	*	modify the projections here according to your model
	*	only modify the appropriate subset of proj!
	*	this is tricky and will probably require my help...
	*/

	if (ss && !Subsets_is_unif(ss))
		Fail("only uniform subsets is done")

	Iwrite3float("tmp,proj.fld", proj, n1_global, n2_global, n3_global)
	Iwrite3float("tmp,image.fld", image, nx_global, ny_global, nz_global)

	sprintf(command, "projector tmp,proj.fld tmp,image.fld %d %d",
		ss ? ss->istart : 0, ss ? ss->nsubset : 1);

	status = system(command);
	if (chat)
		printf("status of command '%s' is %d\n", command, status);

	if (status != 0)
		Fail("system() call to 'projector' failed")

	return 1;
}


/*
*	sys_back()
*	back projector
*/
extern bool sys_back(
const void *DoNotTouch,
float		*back,	/* [nx,ny,nz] backproject into here	*/
const float	*data,	/* [n1,n2,n3] projections data comes in here */
const float	*wi,	/* [n1,n2,n3] projection weights	*/
const Subsets	*ss,	/* subset control structure	*/
const int	chat)	/* 0 for silent, >0 for diagnostics */
{
	(void) DoNotTouch;
	if (chat)
		printf("in sys_back\n");

	/*
	*	copy the subset of the projections here to your work space
	*	and modify as desired, then pass those to fi_back()
	*	only modify the appropriate subset of data!
	*	this is tricky and will probably require my help...
	*/

	if (!fi_back(back, data, sys, wi, ss, chat))
		Fail("fi_back")

	return 1;
}
