/*
*	rp,dynlib,proto.h
*	required prototypes for dynamic library penalty
*
*	Copyright Jan 1998,	Jeff Fessler	University of Michigan
*/

extern int rp_init(
const void *DoNotTouch1,
const void *DoNotTouch2,
const int nx,
const int ny,
const int nz,
const int chat);		/* 0 for silent, >0 for diagnostics */

extern int rp_free(const void *DoNotTouch);

extern double rp_penalty(
const float *image,		/* [nx,ny,nz] image volume	*/
const void *DoNotTouch,
const unsigned char *mask,	/* [nx,ny,nz] binary support mask */
const int nx,			/* image dimensions */
const int ny,
const int nz);

extern int rp_grad(
float	*rx,			/* [nx,ny,nz] output gradient vector */
const float *image,		/* [nx,ny,nz] input current image */
const void *DoNotTouch,
const unsigned char *mask,	/* [nx,ny,nz] binary support mask */
const int nx,			/* image dimensions */
const int ny,
const int nz);

extern double rp_newton1(
const double d1,		/* d1 */
const double n2,		/* n2 */
const float *image,		/* [nx,ny,nz] image */
const int nx,			/* image dimensions */
const int ny,
const int nz,
const void *DoNotTouch,
const double depierro);		/* depierro factor */
