/*
* Composite ASPIRE general header code/def.h
* This software is Copyrighted 1990-1997
* by Jeff Fessler and The University of Michigan
* and is currently distributed to selected noncommercial users
* only with the explicit permission of Jeff Fessler.
* PLEASE DO NOT REDISTRIBUTE THIS CODE.
* Created: Thu Feb 13 22:11:37 EST 2003
*/
#ifdef MATLAB_HOST
#include "mat.h"
#endif
/*
*	def,thread.h
*
*	Copyright 2001-8-22	Jeff Fessler	The University of Michigan
*
*       Must include pthread.h *before* my definitions, because pthread.h
*       sets a __need_timespec flag which affects declarations in time.h
*/

/*
*	this was my attempt to make it work on solaris,
*	which does not seem to have the __need_timespec flag.
*	i gave up since my dual-processor solaris machines are slow anyway
*/
#if 0
typedef struct timespec {
	long int dummy1;
	long int dummy2;
}
#endif

#include <pthread.h>

#define Thread2(func, t1, t2) \
	{ \
		t1.ok = False; \
		t2.ok = False; \
		{ \
		pthread_t thread_id1, thread_id2; \
		if (pthread_create(&thread_id1, NULL, func, (void*) &t1)) \
			Fail("error creating thread1") \
		if (pthread_create(&thread_id2, NULL, func, (void*) &t2)) \
			Fail("error creating thread2") \
		pthread_join(thread_id1, NULL); \
		pthread_join(thread_id2, NULL); \
		} \
		if (!t1.ok || !t2.ok) \
			Fail("thread failed") \
	}
/*
*	def.h
*	Portability definitions
*
*	Copyright Dec. 1994,	Jeff Fessler	University of Michigan
*/

#ifndef DefsEnv
#define DefsEnv

/*
*	set the following flag for compiling on PC/NT/x86
*/
#if defined(Is_pc)
#define	Userand
#define	Need_uint
#define Need_proto_lgamma
#define Need_proto_erf
#define Need_time_h
#endif

#ifdef Use_thread

#endif

#include <stdio.h>
#include <string.h>
#if defined(Need_assert)
#include <assert.h>
#endif
#include <sys/types.h>
#include <ctype.h>
#if defined(__osf__) | defined(Need_time_h)
#include <time.h>
#endif
#if defined(Need_ieeefp)
#include <ieeefp.h>	/* needed for solaris for finite() */
#endif
#if defined(Need_dynlib)
#include <dlfcn.h>	/* needed for dynamic libraries	*/
#endif

#ifdef Use_mpi
#include <mpi.h>
#endif

#if defined(hphp)
#define _INCLUDE_XOPEN_SOURCE
#define Userand48
	extern double drand48(void);
#if !defined(Mmex)
#	define Need_uint
#endif
#endif

#if defined(Need_uint)
	typedef unsigned int	uint;
	typedef unsigned short	ushort;
#endif

#if defined(titan)
#define Isfinite isfinite	/* no finite() on titan */
#define Provide_strstr		/* no strstr() on titan */
#define Need_proto_strstr
#include <vmath.h>
#else
#include <math.h>
#endif

#ifndef M_PI
#define M_PI	3.14159265358979323846
#endif
#ifndef M_SQRT1_2
#define M_SQRT1_2	0.70710678118654752440
#endif
#ifndef M_SQRT2
#define M_SQRT2		1.4142135623730950488
#endif

#ifndef CLOCKS_PER_SEC		/* stupid SunOS doesn't have it */
#	define CLOCKS_PER_SEC 1000000
#endif

#ifndef Clock
	extern clock_t GlobalClock0;
#define	Clock0	GlobalClock0 = clock();
#define	Clock	( (clock() - GlobalClock0) / (double) CLOCKS_PER_SEC )
#endif

/*
*	No stdlib on titan!
*/
#if defined(titan)
	extern void	exit();
	extern char	*calloc(), *malloc();
	extern char	*memcpy(), *memset();
	extern int	free();
#else
#	include <stdlib.h>
#endif

/*
*	Other externs
*/
#ifdef Need_protos_sol2		/* needed for sol2 */
#	define Need_proto_erf
#	define Need_proto_lgamma
#	define Need_proto_random
#endif

#if defined(titan) | defined(sun)
	extern int	bzero(), bcopy();
	/*#	define Free(p)	free((char *) (p)) */
#endif


/*
*	And of course this varies too
*/
#if defined(_SIZE_T_)
#	define Size_t	size_t
#else
#	define Size_t	unsigned
#endif

#if !defined(noConst)
#	define Const	const
#else
#	define Const
#endif

#if !defined(MAXint)
#	define MAXchar		127
#	define MAXbyte		255
#	define MAXshort		32767
#	define MAXint		2147483647
#	define MAXfloat		1e30
#	define MAXdouble	1e300
#endif

/*
*	others
*/


#ifndef No_defs_type

#endif





#ifndef SHRT_MAX
#define SHRT_MAX	32767
#endif
#ifndef SHRT_MIN
#define SHRT_MIN	(-32768)
#endif

/*
* define all the globals that are needed by the macros
*/
#ifndef GlobalsDefinedHere
#	define GlobalsDefinedHere	\
		FILE	*Global_fp_exist;	\
		clock_t GlobalClock0;	\
		int Mpi_rank=0, Mpi_numprocs=1;
#endif

#endif /* DefsEnv */
/*
*	def,macro.h
*	favorite macro definitions
*
*	Copyright Dec. 1994,	Jeff Fessler	University of Michigan
*/

#ifndef Defs_macro
#define Defs_macro

#define	Chat		((chat > 0) ? (chat-1) : 0)

#define	Calloc(n,s)	calloc((unsigned) (n), (unsigned) (s))

#define	Swab(s,d,n)	{ \
	if ((s) == (d)) Exit("swab problem") \
	swab((char *)(s), (char *)(d), n); }

#define	Nonull(str)	((str) ? (str) : "null")

#define Argflt(n,def)	(argc > n ? atof(argv[n]) : def)
#define Argint(n,def)	(argc > n ? atoi(argv[n]) : def)
#define Argstr(n,def)	(argc > n ? argv[n] : def)
#define Argstn(n)	((argc > n && strcmp(argv[n], "-")) ? argv[n] : NULL)

#define Isdigit(c)	(('0' <= (c)) && ((c) <= '9'))

/* use -DIsfinite=isfinite on lnx86 */
#if !defined(Isfinite)
#define Isfinite(x)	finite(x)
#endif


#ifndef Notes
#	define Notes(msg)	{ if (chat) { \
		printf("Note %s %d: ", __FILE__, __LINE__); \
		printf msg; (void)fflush(stdout); } }
#endif

#ifndef Note
#	define Note(msg)	\
	{ (void)fprintf(stdout, "Note %s %d: %s\n", __FILE__, __LINE__, msg); \
	(void)fflush(stdout); }
#endif

#ifndef Note1
#	define Note1(msg, arg)	\
	{ char Zstr[1024]; (void)sprintf(Zstr, msg, arg); Note(Zstr) }
#endif

#ifndef Note2
#	define Note2(msg, a1, a2)	\
	{ char Zstr[1024]; (void)sprintf(Zstr, msg, a1, a2); Note(Zstr) }
#endif

#ifndef Note3
#	define Note3(msg, a1, a2, a3)	\
	{ char Zstr[1024]; (void)sprintf(Zstr, msg, a1, a2, a3); Note(Zstr) }
#endif

#ifndef Note4
#	define Note4(msg, a1, a2, a3, a4)	\
	{ char Zstr[1024]; (void)sprintf(Zstr, msg, a1, a2, a3, a4); Note(Zstr) }
#endif

#ifndef Note5
#	define Note5(msg, a1, a2, a3, a4, a5)	\
	{ char Zstr[1024]; (void)sprintf(Zstr, msg, a1, a2, a3, a4, a5); Note(Zstr) }
#endif

#ifndef Note6
#	define Note6(msg, a1, a2, a3, a4, a5, a6)	\
	{ char Zstr[1024]; (void)sprintf(Zstr, msg, a1, a2, a3, a4, a5, a6); Note(Zstr) }
#endif

#ifndef Warn
#	define Warn(msg)	{ \
	(void)fprintf(stderr, "WARN %s %d: %s\n", __FILE__, __LINE__, msg); \
	(void)fflush(stderr); }
#endif

#ifndef Warn1
#	define Warn1(msg, arg)	\
	{ char Zstr[1024]; (void)sprintf(Zstr, msg, arg); Warn(Zstr) }
#endif

#ifndef Warn2
#	define Warn2(msg, a1, a2)	\
	{ char Zstr[1024]; (void)sprintf(Zstr, msg, a1, a2); Warn(Zstr) }
#endif

#ifndef Warn3
#	define Warn3(msg, a1, a2, a3)	\
	{ char Zstr[1024]; (void)sprintf(Zstr, msg, a1, a2, a3); Warn(Zstr) }
#endif

#ifndef Warn4
#	define Warn4(msg, a1, a2, a3, a4)	\
	{ char Zstr[1024]; (void)sprintf(Zstr, msg, a1, a2, a3, a4); Warn(Zstr) }
#endif

#ifndef Fail
#	define Fail(msg)	{ \
	(void)fprintf(stderr, "FAIL %s %d: %s\n", __FILE__, __LINE__, msg); \
	(void)fflush(stderr); \
	return Failure; }
#endif

#ifndef Fail1
#	define Fail1(msg, arg)	\
	{ char Zstr[1024]; (void)sprintf(Zstr, msg, arg); Fail(Zstr) }
#endif

#ifndef Fail2
#	define Fail2(msg, a1, a2)	\
	{ char Zstr[1024]; (void)sprintf(Zstr, msg, a1, a2); Fail(Zstr) }
#endif

#ifndef Fail3
#	define Fail3(msg, a1, a2, a3)	\
	{ char Zstr[1024]; (void)sprintf(Zstr, msg, a1, a2, a3); Fail(Zstr) }
#endif

#ifndef Fail4
#	define Fail4(msg, a1, a2, a3, a4)	\
	{ char Zstr[1024]; (void)sprintf(Zstr, msg, a1, a2, a3, a4); Fail(Zstr) }
#endif

#ifndef Exit
#	define Exit(msg)	{ \
	(void)fprintf(stderr, "EXIT %s %d: %s\n", __FILE__, __LINE__, msg); \
	exit(-1); }
#endif

#ifndef Call
#define Call(fun, arg)		{ if (!(fun arg)) Fail(#fun) }
#define Call1(fun, arg, str)	{ if (!(fun arg)) Fail1(#fun" %s", str) }
#endif

/*
*	And those pesky IO functions....
*/
#if defined(titan)
#	define Fread(p,s,n,f)	fread ((char *)(p), (Size_t)(s), (int)(n), f)
#	define Fwrite(p,s,n,f)	fwrite((char *)(p), (Size_t)(s), (int)(n), f)
#elif defined(sun)
#	define Fread(p,s,n,f)	fread ((char *)(p), (int)(s), (int)(n), f)
#	define Fwrite(p,s,n,f)	fwrite((char *)(p), (int)(s), (int)(n), f)
#else
#	define Fread(p,s,n,f)	fread ((void *)(p), (Size_t)(s), (Size_t)(n), f)
#	define Fwrite(p,s,n,f)	fwrite((cvoid *)(p), (Size_t)(s), (Size_t)(n), f)
#	define Strncat(s1,s2,n)	strncat(s1, s2, (int) (n))
#endif

#if defined(titan) | defined(sun)
#define Memset(p,c,n)		memset((char *)(p), (int)(c), (int)(n));
#define Memcpy(t,f,n)		memcpy((char *)(t), (char *)(f), (int)(n));
#define Strncat(s1,s2,n)	strncat(s1, s2, (Size_t) (n))
#define Bzero(p,n)	bzero((char *) (p), (int) ((n) * sizeof(*(p))));
#define Bcopy(s,d,n)	bcopy((char *) (s), (char *) (d), (int) ((n) * sizeof(*(s))));
#else
#define Memset(p,v,n)	(void)memset((void *) (p), v, (Size_t) (n));
#define Memcpy(d,s,n)	{ if ((d) == (s)) Exit("Identical memcpy pointers") \
		else (void)memcpy((void *) (d), (cvoid *) (s), (Size_t) (n)); }
#define Bzero(p,n)	Memset(p, 0, (n) * sizeof(*(p)))
#define Bcopy(s,d,n)	Memcpy(d, s, (n) * sizeof(*(s)))
#endif

/*
*	The suffix "0" means return 0 on error.
*/
#ifndef FileExist
	/* (!fclose(fopen(name, "rb"))) did not work on linux */
	extern FILE *Global_fp_exist;
#define FileExist(name)		((Global_fp_exist = fopen(name, "rb"), \
				Global_fp_exist && !fclose(Global_fp_exist)))
#endif
#define	Fopen0(fp,n,t)		{if ( !(fp = fopen(n, t)) )	\
					Fail1("fopen '%s'", n)}
#define	Fopen0r(fp,n)		Fopen0(fp,n,"rb")
#define	Fopen0w(fp,n)		Fopen0(fp,n,"wb")
#define	Fopen0e(fp,n)		Fopen0(fp,n,"rb+")	/* for editing */
#define	Fflush0(fp)		{if (fflush(fp))	Fail("fflush")}
/* seek from start of file */
#define	Fseek0(fp,n)		{if (fseek(fp, (long) (n), 0))	\
					Fail1("fseek %d", n)}
#define	Fskip0(fp,n)		{if (fseek(fp, (long) (n), 1))	\
					Fail1("fseek1 %d", n)}
#define	Fclose0(fp)		{if (fclose(fp))	Fail("fclose")}
#define	Fread0(p,s,n,fp)	{uint ZF = Fread(p, s, n, fp); \
				if (ZF != (unsigned) (n)) \
				Fail3("fread found %d bytes, not %d at %d", ZF, (n), (int) ftell(fp))}
#define	Fwrite0(p,s,n,fp)	{if (((unsigned) (n)) != (unsigned) Fwrite(p, s, n, fp)) Fail("fwrite")}


#if defined(Userand48)
#	define Rand01		drand48()
#	define Seeder(s)	srand48(s)
#elif defined(Userand)				/* for PC */
#	define Rand01		(rand() / RAND_MAX)
#	define Seeder(s)	srand(s)
#else
#	define Rand01		(random() / 2147483647.0)
#	define Seeder(s)	srandom(s)
#endif

/*
*	The remaining macro definitions should be environment independent
*/

#define Sqr(x)		((x) * (x))
#define Odd(n)		((n)/2 != ((n)+1)/2)
#define Even(n)		((n)/2 == ((n)+1)/2)
#ifndef Abs
#	define Abs(x)	(((x) >= 0) ? (x) : (-x))
#endif
#ifndef Max
#	define Max(x,y)	(((x) > (y)) ? (x) : (y))
#endif
#ifndef Min
#	define Min(x,y)	(((x) < (y)) ? (x) : (y))
#endif
#ifndef Rint	/* round to nearest integer, ala rint() */
#	define Rint(x)	( (int) ((x) >= 0 ? ((x) + 0.5) : ((x) - 0.5)) )
	/* formerly ((int) ((x) + 0.5)), which is wrong for negatives! */
#endif

#define Floor(x)	((int) floor(x))
#define Ceil(x)		((int) ceil(x))

#ifndef True
#	define	True	((bool) 1)
#endif
#ifndef False
#	define	False	((bool) 0)
#endif

#define Streq(a,b)	(!strcmp(a,b))
#define Streqn(a,b,n)	(!strncmp(a,b,n))

#define	Success	((bool) 1)
#define	Failure	((bool) 0)
#define	Ok	return Success;

#ifdef CountAlloc

#define	Alloc0(ptr,type,n,s)	{ \
	if ( !((ptr) = (type *) io_mem_alloc((uint) (n), (uint) (s), \
		__FILE__, __LINE__, #ptr)) ) \
		Fail2("io_mem_alloc(%d,%d)", (int) (n), (int) (s)) }
#define Free(p)		{ \
		if (!io_mem_free((void *) (p), __FILE__, __LINE__, #p)) { \
			Warn2("bug free %s %d", __FILE__, __LINE__) \
			Exit("bug") } }
#define Free0(p)	{ \
		Call(io_mem_free, ((void *) (p), __FILE__, __LINE__, #p)) \
		p = NULL; }

#define PrintAlloc	io_mem_print(__FILE__, __LINE__, 1);
#define MemUsed		io_mem_usage(__FILE__, __LINE__, Chat);
#define MemInfo(p)	io_mem_info((cvoid *) p, __FILE__, __LINE__, #p);

#else

#define	Alloc0(ptr,type,n,s)	{ \
	if ( !((ptr) = (type *) calloc((unsigned) (n), (unsigned) (s))) ) \
		Fail2("alloc %d %d", (int) (n), (int) (s)) }
#define Free(p)		free((void *) (p))
#define Free0(p)	Free(p);

#define PrintAlloc	{}
#define MemUsed		{}
#define MemInfo(p)	{}

#endif

#define Mem0(p,n)	Alloc0(p, void, n, sizeof(*(p)))

#endif /* Defs_macro */
/*
*	def,type.h
*	type definitions
*
*	Copyright Feb. 1995,	Jeff Fessler	University of Michigan
*/

#ifndef Defs_type
#define Defs_type

/* uint will come from sys/types.h	*/
#if !defined(NO_BOOL) && !defined(mat_h)	/* thank you MathWorks */
typedef int		bool;	/* True or False, Success Or Failure	*/
#endif
typedef short		word;	/* two byte integers			*/
typedef unsigned short	uword;	/* two byte integers, unsigned		*/
typedef unsigned char	byte;
typedef double	TypeCalc;	/* fastest floating point type		*/

	typedef Const char	cchar;
	typedef Const byte	cbyte;
	typedef Const short	cshort;
	typedef Const int	cint;
	typedef Const unsigned int	cuint;
	typedef Const float	cfloat;
	typedef Const double	cdouble;
	typedef Const void	cvoid;
	typedef Const int	cbool;

	typedef cchar		*pcchar;
	typedef const pcchar	*pcpcchar;	/* for argv */
	typedef cfloat		*pcfloat;

#endif /* Defs_type */
/*
*	def,inline.h
*
*	Simple vector operations done in-line.
*
*	Copyright Dec. 1994,	Jeff Fessler	University of Michigan
*/

#define	whileZn	for (; Zn; --Zn)

/*
*	v op c(onstant)
*/
#define Inline1vector(type1, v1, op, type2, c, n)	\
{				\
register type1	*Z1 = v1;	\
register type2	Zc = (type2) c;	\
register int	Zn = n;		\
	whileZn			\
		*Z1++ op Zc;	\
}

/*
*	v1 op v2
*/
#define Inline2vector(type1, v1, op, type2, v2, n)	\
{				\
register type1	*Z1 = v1;	\
register type2	*Z2 = v2;	\
register int	Zn = n;		\
	whileZn {		\
		*Z1++ op (*Z2);	\
	++Z2; }			\
}




/*
*	Vector with Scalar
*/

/*
*	v *= c(onstant)
*/
#define VectScale(type, v, c, n)	\
	Inline1vector(type, v, *=, cdouble, c, n)

/*
*	v += c(onstant)
*/
#define VectInc(type, v, c, n)	\
	Inline1vector(type, v, +=, cdouble, c, n)

/*
*	v = c(onstant)
*/
#define VectSet(type, v, c, n)	\
	Inline1vector(type, v, =, Const type, c, n)

/*
*	v = Max(v,0)
*/
#define VectNonneg(type, v, n)	\
{				\
register type	*Zv = v;	\
register int	Zn = n;		\
	whileZn {		\
		if (*Zv < 0) *Zv = 0;	\
		++Zv; }		\
}


/*
*	s = sum(v)
*/
#define VectAccum(type, s, v, n)	\
{					\
register double	Zsum = 0.;		\
register Const type *Zv = v;		\
register int	Zn = n;			\
	whileZn				\
		Zsum += *(Zv++);	\
	s = Zsum;			\
}


/*
*	s = sum(|v|)
*/
#define VectNorm1(type, s, v, n)	\
{					\
register Const type *Zv = v;		\
register int	Zn = n;			\
register double	Zsum = 0;		\
	whileZn {			\
		Zsum += Abs(*Zv);	\
		++Zv;			\
	} s = Zsum;			\
}


/*
*	s = <v,v>
*/
#define VectNorm2(type, s, v, n)	\
{					\
register Const type *Zv = v;	\
register int	Zn = n;			\
register double	Zsum = 0;		\
	whileZn {			\
		Zsum += *Zv * *Zv;	\
		++Zv;			\
	} s = Zsum;			\
}


/*
*	s = <v,v>_w
*/
#define VectNorm2wtd(type, s, v, w, n)	\
{					\
register Const type *Zv = v;	\
register Const type *Zw = w;	\
register int	Zn = n;				\
register double	Zsum = 0;			\
	whileZn {				\
		Zsum += *Zv * *Zv * *Zw;	\
		++Zv; ++Zw;			\
	} s = Zsum;				\
}


/*
*	[v; v; ...; v] repeated nrep times
*/
#define VectRepeat(type, v, npoint, nrep)	\
{					\
register type *Zv = v;			\
Const int	Zn = npoint;		\
Const int	Zr = nrep;		\
int	Zi;				\
	for (Zi=1; Zi < Zr; Zi++)	\
		Bcopy(Zv, Zv+Zi*Zn, Zn)	\
}


/*
*	Vector with Vector
*/

/*
*	v1 = v2
*/
#define VectCopy(type1, v1, type2, v2, n)	\
	Inline2vector(type1, v1, =, Const type2, v2, n)

/*
*	r *= v
*/
#define VectMul(type, r, v, n)	\
	Inline2vector(type, r, *=, Const type, v, n)

/*
*	r /= v
*/
#define VectDiv(type, r, v, n)	\
	Inline2vector(type, r, /=, Const type, v, n)

/*
*	r += v
*/
#define VectAdd(type, r, v, n)	\
	Inline2vector(type, r, +=, Const type, v, n)

/*
*	r += const * v
*/
#define VectAddScale(type, r, c, v, n)	\
	Inline2vector(type, r, += c *, Const type, v, n)

/*
*	r -= v
*/
#define VectSub(type, r, v, n)	\
	Inline2vector(type, r, -=, Const type, v, n)

/*
*	r += v1 + v2
*/
#define VectInc2(type, r, v1, v2, n)	\
{					\
register type	*Zr = r;		\
register Const type *Z1 = v1;		\
register Const type *Z2 = v2;		\
register int	Zn = n;			\
	whileZn				\
		*Zr++ += *(Z1++) + *(Z2++);	\
}

/*
*	r = r / v or 0 if v=0
*/
#define VectDiv0(type, r, v, n)	\
{				\
register type *Zr = r;		\
register Const type *Zv = v;	\
register int	Zn = n;		\
	whileZn {		\
		if (*Zv)	\
			*Zr++ /= *Zv;	\
		else {			\
			*Zr++ = 0;	\
		}			\
		++Zv; }		\
}


/*
*	s = <v1, v2>
*/
#define VectInprod3d(s, type1, v1, type2, v2, n1, n2, n3)	\
{					\
register Const type1 *Z1 = v1;		\
register Const type2 *Z2 = v2;		\
int	Zn = n3;		\
cint	Zn2 = n2;		\
register cint	Zn1 = n1;	\
double	Zsum = 0.;		\
	whileZn	{		\
		int Zi2;		\
		double	Zsum2 = 0.;	\
		for (Zi2=0; Zi2 < Zn2; ++Zi2) {			\
			register int Zi1;			\
			register double	Zsum1 = 0.;		\
			for (Zi1=0; Zi1 < Zn1; ++Zi1)		\
				Zsum1 += *(Z1++) * *(Z2++);	\
			Zsum2 += Zsum1;				\
		}		\
		Zsum += Zsum2;	\
	}			\
	s = Zsum;		\
}

#define VectInprod2d(s, type1, v1, type2, v2, n1, n2)	\
	VectInprod3d(s, type1, v1, type2, v2, n1, n2, 1)

/*
*	s = <v1, v2>
*/
#define VectInprod(type, s, v1, v2, n)	\
{					\
register Const type *Z1 = v1;		\
register Const type *Z2 = v2;		\
register int	Zn = n;			\
register double	Zsum = 0.;		\
	whileZn				\
		Zsum += *(Z1++) * *(Z2++);	\
	s = Zsum;				\
}


/*
*	s = <v1, v2.^2>
*/
#define VectInprod2(type, s, v1, v2, n)	\
{					\
register Const type *Z1 = v1;		\
register Const type *Z2 = v2;		\
register int	Zn = n;			\
register double	Zsum = 0.;		\
	whileZn {			\
		Zsum += *(Z1++) * *Z2 * *Z2;	\
		++Z2;			\
	} s = Zsum;			\
}


/*
*	s = <v1, v2.^2>
*	Supposes v2 is mostly zeros
*/
#define VectInprod2_0(type, s, v1, v2, n)	\
{					\
register Const type *Z1 = v1;		\
register Const type *Z2 = v2;		\
register int	Zn = n;			\
register double	Zsum = 0.;		\
	whileZn {			\
		if (*Z2)		\
			Zsum += *Z1 * *Z2 * *Z2;	\
		++Z1; ++Z2;		\
	} s = Zsum;			\
}


/*
*	min and max of vector
*/
#define VectMinMax(type1, vmin, vmax, type2, v, n)	\
{						\
register Const type2	*Zv = v;		\
register type1	Zmin = (type1) *Zv;		\
register type1	Zmax = (type1) *Zv++;		\
register int	Zn = n-1;			\
	whileZn {				\
		if (*Zv > Zmax)	Zmax = *Zv;	\
		else				\
		if (*Zv < Zmin)	Zmin = *Zv;	\
		++Zv;				\
	}					\
	vmin = Zmin;				\
	vmax = Zmax;				\
}


/*
*	min and max of vector, and min > 0
*/
#define VectMinMax0(type1, this_type_max, vmin, vmin0, vmax, type2, v, n)	\
{						\
register Const type2	*Zv = v;		\
register type1	Zmin = (type1) *Zv;		\
register type1	Zmin0 = (type1) (Zmin > 0 ? Zmin : this_type_max);	\
register type1	Zmax = (type1) *Zv++;			\
register int	Zn = n-1;			\
	whileZn {				\
		if (*Zv > Zmax)	Zmax = *Zv;	\
		else				\
		if (*Zv < Zmin)	Zmin = *Zv;	\
		if (*Zv > 0 && *Zv < Zmin0)	Zmin0 = *Zv;	\
		++Zv;				\
	}					\
	vmin = Zmin;				\
	vmin0 = Zmin0;				\
	vmax = Zmax;				\
}


/*
*	debugging
*/

#define VectInfo(type, v, n, msg) { \
	double Ztmin, Ztmax, Ztmin0, ZZsum; \
	VectMinMax0(type, MAX##type, Ztmin, Ztmin0, Ztmax, type, v, n) \
	VectAccum(type, ZZsum, v, n) \
	Note6("%s [%d] min=%g min0=%g max=%g sum=%g", \
		msg, n, Ztmin, Ztmin0, Ztmax, ZZsum) }
/*
*	def,alloc.h
*	Copyright Apr. 1997,	Jeff Fessler	University of Michigan
*/

#ifndef DefAlloc
#define DefAlloc

/* trick: thanks to Mathworks and NO_BOOL, use "int" here rather than bool */
extern void	*io_mem_alloc(cuint n, cuint s, cchar *, cint, cchar *);
extern bool	io_mem_free(void *p, cchar *, cint, cchar *);
extern bool	io_mem_print(cchar *, cint, cint);
extern bool	io_mem_usage(cchar *, cint, cint);
extern bool	io_mem_info(cvoid *, cchar *, cint, cchar *);


#endif /* DefAlloc */
/*
*	def,proto.h
*	Prototypes
*
*	Copyright May 2000,	Jeff Fessler	The University of Michigan
*/

#ifndef DefProto
#define DefProto

#ifdef Need_proto_strstr
	extern char *strstr(char *, char *);
#endif

#ifdef Need_proto_random
	extern void	srandom(unsigned);
	extern long	random(void);
#endif

#ifdef Need_proto_lgamma
	extern double lgamma(cdouble);
#endif

#ifdef Need_proto_erf
	extern double erf(cdouble);
#endif

#endif	/* DefProto */
/*
* Composite ASPIRE io header code/def.h
* This software is Copyrighted 1990-1997
* by Jeff Fessler and The University of Michigan
* and is currently distributed to selected noncommercial users
* only with the explicit permission of Jeff Fessler.
* PLEASE DO NOT REDISTRIBUTE THIS CODE.
* Created: Thu Feb 13 22:11:38 EST 2003
*/

/* Source: ../io/defs-io.h */
#ifndef Defs_io
#define Defs_io
#ifdef Ihost_xdr
#include <rpc/types.h>
#include <rpc/xdr.h>
#endif
#ifndef No_defs_env
#endif
	extern int Mpi_rank, Mpi_numprocs;
#ifndef Ichat
#	define Ichat	Chat
#endif
#define Iswap87654321(p,n)	io_swap_87654321((byte *) (p), (int) (n));
#define Iswap4321(p,n)		io_swap_4321((byte *) (p), (int) (n));
#define Iswap21(p,n)		io_swap_21((byte *) (p), (int) (n));
#define Ibyte(type)	Streq(type, "byte")
#define Ishort(type)	Streqn(type, "short", 5)
#define Iint(type)	Streq(type, "int")
#define Ifloat(type)	Streq(type, "float")
#define Idouble(type)	Streq(type, "double")
#define Ireal(type)	(Ifloat(type) || Idouble(type))
#define Imax_length_data_type	11
#define I5dim(p1, p2, p3, p4, p5, file) \
	Call1(io_head, (p1, p2, p3, p4, p5, NULL, NULL, file, NULL, Ichat), file)
#define I4dim(p1, p2, p3, p4, file)	I5dim(p1, p2, p3, p4, NULL, file)
#define I3dim(p1, p2, p3, file)		I4dim(p1, p2, p3, NULL, file)
#define Islices(type, data, nx, ny, nz, nf, \
			slice0, slice1, i4a, i4b, file) \
		Call1(io_read_5d, ((void *) (data), type, NULL, \
			nx, ny, nz, nf, 0, slice0, slice1, i4a, i4b, 0, 0, \
			file, NULL, NULL, False, False, Ichat), file)
#define Islices_byte(data, nx, ny, slice0, slice1, file) \
		Islices("byte", data, nx, ny, 0, 0, slice0, slice1, 0, 0, file)
#define Islices_short(data, nx, ny, slice0, slice1, file) \
		Islices("short", data, nx, ny, 0, 0, slice0, slice1, 0, 0, file)
#define Islices_float(data, nx, ny, slice0, slice1, file) \
		Islices("float", data, nx, ny, 0, 0, slice0, slice1, 0, 0, file)
#define Iread4d(type, data, nx, ny, nz, nf, if0, if1, file) \
	Islices(type, data, nx, ny, nz, nf, 0, Max((nz)-1,0), if0, if1, file)
#define Iread4byte(data, nx, ny, nz, nf, if0, if1, file) \
		Iread4d("byte", data, nx, ny, nz, nf, if0, if1, file)
#define Iread4float(data, nx, ny, nz, nf, if0, if1, file) \
		Iread4d("float", data, nx, ny, nz, nf, if0, if1, file)
#define Iread3d(type, data, nx, ny, nz, frame, file) \
		Iread4d(type, data, nx, ny, nz, 0, frame, frame, file)
#define Iread3byte(data, nx, ny, nz, file) \
		Iread3d("byte", data, nx, ny, nz, 0, file)
#define Iread3short(data, nx, ny, nz, file) \
		Iread3d("short", data, nx, ny, nz, 0, file)
#define Iread3int(data, nx, ny, nz, file) \
		Iread3d("int", data, nx, ny, nz, 0, file)
#define Iread3float(data, nx, ny, nz, file) \
		Iread3d("float", data, nx, ny, nz, 0, file)
#define Iread3double(data, nx, ny, nz, file) \
		Iread3d("double", data, nx, ny, nz, 0, file)
#define Islice(type, data, nx, ny, slice, frame, file) \
		Islices(type, data, nx, ny, 0, 0, slice, slice, frame, frame, file)
#define Islice_byte(data, nx, ny, slice, file) \
		Islice("byte", data, nx, ny, slice, 0, file)
#define Islice_short(data, nx, ny, slice, file) \
		Islice("short", data, nx, ny, slice, 0, file)
#define Islice_float(data, nx, ny, slice, file) \
		Islice("float", data, nx, ny, slice, 0, file)
#define Iwrite(file, data, type, dims, ndim, name) \
	if (Mpi_rank == 0) { \
		if (!io_write_n(file, data, type, 1., dims, ndim,	\
			0, NULL, NULL, name, True, Ichat)) {		\
			cchar *Itmpfile = "/tmp/t.fld";			\
			if (Streq((file)+strlen(file)-4, ".ppm"))	\
				Itmpfile = "/tmp/t.ppm";		\
			else if (Streq((file)+strlen(file)-4, ".pgm"))	\
				Itmpfile = "/tmp/t.pgm";		\
			Note2("io_write(%s) failed, trying %s", file, Itmpfile)\
			if (!io_write_n(Itmpfile, data, type, 1., dims, ndim, \
				0, NULL, NULL, name, True, 9)) \
				Fail2("io_write(%s,%s)", file, Itmpfile) \
		} \
	}
#define Iwrite4(file, data, type, nx, ny, nz, nf, name) { \
	int Idims[4]; Idims[0]=nx; Idims[1]=ny; Idims[2]=nz; Idims[3]=nf; \
	Iwrite(file, data, type, Idims, 2 + (nz > 0) * (1 + (nf > 0)), name) }
#define Iwrite3(file, data, type, nx, ny, nz, name) { \
		int Idims[3]; Idims[0]=nx; Idims[1]=ny; Idims[2]=nz; \
		Iwrite(file, data, type, Idims, 2 + (nz > 0), name) }
#define Iwrite2(file, data, type, nx, ny, name) { \
		int Idims[2]; Idims[0]=nx; Idims[1]=ny; \
		Iwrite(file, data, type, Idims, 1 + (ny > 0), name) }
#define Iwrite4float(file, data, n1, n2, n3, n4) \
		Iwrite4(file, data, "float", n1, n2, n3, n4, NULL)
#define Iwrite3byte(file, data, nx, ny, nz) \
		Iwrite3(file, data, "byte", nx, ny, nz, NULL)
#define Iwrite3short(file, data, nx, ny, nz) \
		Iwrite3(file, data, "short", nx, ny, nz, NULL)
#define Iwrite3int(file, data, nx, ny, nz) \
		Iwrite3(file, data, "int", nx, ny, nz, NULL)
#define Iwrite3float(file, data, nx, ny, nz) \
		Iwrite3(file, data, "float", nx, ny, nz, NULL)
#define Iwrite3double(file, data, nx, ny, nz) \
		Iwrite3(file, data, "double", nx, ny, nz, NULL)
#define Iwrite2byte(file, data, nx, ny) \
		Iwrite2(file, data, "byte", nx, ny, NULL)
#define Iwrite2short(file, data, nx, ny) \
		Iwrite2(file, data, "short", nx, ny, NULL)
#define Iwrite2float(file, data, nx, ny) \
		Iwrite2(file, data, "float", nx, ny, NULL)
#define Iwrite2double(file, data, nx, ny) \
		Iwrite2(file, data, "double", nx, ny, NULL)
#define Isave(root, int1, int2, data, type, nx, ny, nz, init)	{ \
	if (Mpi_rank == 0) \
		Call1(io_save, (root, int1, int2, (void *) (data), type, nx, ny, nz, init, Ichat), root) \
	}
#define Isave_float(root, int1, int2, data, nx, ny, nz, init)	\
		Isave(root, int1, int2, data, "float", nx, ny, nz, init)
#define Isize(type)	((int) \
	(Ibyte(type)	? sizeof(byte) : \
	(Ishort(type)	? sizeof(short) : \
	(Iint(type)	? sizeof(int) : \
	(Ifloat(type)	? sizeof(float) : \
	(Idouble(type) ? sizeof(double) : \
	0))))))
#define Inonneg(data, type, nn)	{ \
	if (Ibyte(type))	Fail("byte nonnegative?")	\
	else if (Ishort(type))	VectNonneg(short,	data, nn) \
	else if (Iint(type))	VectNonneg(int,		data, nn) \
	else if (Ifloat(type))	VectNonneg(float,	data, nn) \
	else if (Idouble(type))	VectNonneg(double,	data, nn) \
	else Fail1("unknown datatype '%s'", type) }
typedef enum {
	Itype_error,
	Itype_avs,
	Itype_gif,
	Itype_matlab,
	Itype_pet,
	Itype_pgm,
	Itype_ppm,
	Itype_raw}
Itype;
#define Itype_is_avs(fn)	(fn->suffix_type == Itype_avs)
#define Itype_is_gif(fn)	(fn->suffix_type == Itype_gif)
#define Itype_is_matlab(fn)	(fn->suffix_type == Itype_matlab)
#define Itype_is_pet(fn)	(fn->suffix_type == Itype_pet)
#define Itype_is_pgm(fn)	(fn->suffix_type == Itype_pgm)
#define Itype_is_ppm(fn)	(fn->suffix_type == Itype_ppm)
#define Itype_is_raw(fn)	(fn->suffix_type == Itype_raw)
typedef struct {
	char	*name;
	char	*suffix;
	Itype	suffix_type;
	int	offset;
	bool	flag_offset;
	bool	overwrite;
} Ifileinfo;
typedef enum {
	io_argv_int,
	io_argv_dbl,
	io_argv_str
} io_argv_type;
#define Aint(str, var, def) \
	{ cint Zz = def; \
	Call(io_argv_get, ((void *) &var, &Zz, #str, io_argv_int, argc, argv)) }
#define Adbl(str, var, def) \
	{ cdouble Zz = def; \
	Call(io_argv_get, ((void *) &var, &Zz, #str, io_argv_dbl, argc, argv)) }
#define Astr(str, var, def) \
	{ cchar *Zz = def; \
	Call(io_argv_get, ((void *) &var, &Zz, #str, io_argv_str, argc, argv)) }
#endif

/* Source: ../io/decs-io.h */
#ifndef DECS_IO
#define DECS_IO
extern int	io_type_suffix(cchar *);
extern Ifileinfo *io_file_parse(cchar *, cchar *, cint);
extern bool	io_fileinfo_free(Ifileinfo *);
extern char	*io_file_data_type(cchar *file, cint chat);
extern bool	io_head(int *, int *, int *, int *, int *, char *, bool *,
			cchar *, cchar *, cint);
extern void	io_help(void);
extern bool	io_read_5d(void *, cchar *, double *,
			cint, cint, cint, cint, cint,
			cint, cint, int, int, int, int,
			cchar *, cchar *, cchar *, cbool, cbool, cint);
extern bool	io_read_some_slices(cchar*, byte *, cchar *,
			cint, cint, cint, cint, cint, cint);
typedef bool (*Isave2_t)(cfloat *image, cint nx, cint ny, cint ii);
#define Isave2_dec(f)	Isave2_t f
extern void	io_save_init(cchar *, cchar *, cint, cint);
extern bool	io_save_file(cfloat *image, cint nx, cint ny, cint ii);
extern bool	io_save_pop(cfloat *image, cint nx, cint ny, cint ii);
extern bool	io_save(cchar *, cint, cint, cvoid *, cchar *, cint, cint, cint, cchar *, cint);
typedef bool (*Isave3_t)(cfloat *image, cint nx, cint ny, cint nz, cint ii, cint chat);
#define Isave3_dec(f)	Isave3_t f
extern void	io_save3_help(void);
extern bool	io_save3_init(cchar *, cchar *, cchar *, cint, cint, cint, cint, cint);
extern bool	io_save3_iter(cfloat *, cint, cint, cint, cint, cint);
extern bool	io_save3_file(cchar *, cfloat *, cint, cint, cint, cint);
extern bool	io_save3_free(void);
extern bool	io_save_stack_init(cint, cint, cint, cint, cchar *);
extern bool	io_save_stack(cfloat *image, cint nx, cint ny, cint ii);
extern bool	io_save_stack_file(cchar *file);
extern bool	io_save_stack_free(void);
extern bool	io_write_n(cchar *, cvoid *, cchar *, cdouble, cint *,
			cint, int, cchar *, cchar *, cchar *, cbool, cint);
extern bool	io_pop_3(cvoid *, cchar *, cint, cint, cint, cchar *, cint, cint);
#if 0
	THESE ARE DECLARED IN def,alloc.h
extern void	*io_mem_alloc(cuint, cuint, cchar *, cint, cchar *);
extern bool	io_mem_free(void *p, cchar *, cint, cchar *);
extern void	io_mem_print(cchar *, cint, cchar *, cint);
extern void	io_mem_usage(cchar *, cint, cint);
#endif
extern bool	io_argv_get(void *, cvoid *, cchar *, io_argv_type, cint, pcpcchar);
#ifdef Provide_isfinite
extern bool	isfinite(cdouble);
#endif
extern bool	io_convert(void *, cchar *, double *, cvoid *, cchar *,
			double, cint, cbool, cbool, cint);
extern void	io_min_max(FILE *, cvoid *, cchar *, cchar *, cint);
extern void	io_slices_help(void);
extern bool	io_slices(int *p_nz, int *, int *, cint, cchar *, cint);
extern void	io_frames_help(void);
extern bool	io_frames(int *, int *, int *, cint,
			int *, int *, int *, cint, cchar *, cint);
extern bool	io_write_eps(FILE *, cbyte *, cint, cint, cbool,
			cdouble, cdouble, cdouble, cbool, cbool, cchar *);
extern bool	io_read_asc_4d(void *, cchar *, double *, cint, cint, cint,
		cint, cint, cint, cint, FILE *, cchar *, cbool, cbool, cint);
extern bool	io_read_bin_4d(void *, cchar *, double *, cint, cint, cint,
			cint, cint, cint, cint, FILE *, cchar *, cbool, cbool, cbool, cint);
extern bool	io_byte_255(byte *, double *, cvoid *, cchar *,
			cdouble, cdouble, cdouble, cbool, cint);
extern bool	io_short_32000(short *, double *, cvoid *, cchar *,
			cdouble, cdouble, cdouble, cbool, cint);
extern bool	io_cpu_has_xdr_byte_order(void);
extern void	io_swap_21(byte *, int);
extern void	io_swap_4321(byte *, int);
extern void	io_swap_87654321(byte *, int);
extern bool	io_read_xdr_4d(void *, cchar *, double *, cint, cint, cint,
		cint, cint, cint, cint, FILE *, cchar *, cbool, cbool, cint);
extern bool	io_write_xdr(FILE *, cvoid *, cchar *, cuint, cint);
#ifdef Ihost_xdr
extern bool	io_do_xdr(cvoid *, cchar *, cuint, XDR *);
#endif
#endif

/* Source: ../io/avs/defs-io-avs.h */
#ifndef DefsIoAvs
#define DefsIoAvs
#define IoAvsMaxDim		10
#if 0
#define FOUND_NDIM		1
#define FOUND_DIMN1		1 << 1
#define FOUND_NSPACE		1 << 2
#define FOUND_VECLEN		1 << 3
#define FOUND_TYPE		1 << 4
#define FOUND_UNIFORM		1 << 5
#endif
typedef enum {
	AvsFileLocal,
	AvsFileExternalAscii,
	AvsFileExternalBinary,
	AvsFileMultipleBinary
} AvsFileType;
typedef struct {
	int	ndim;
	int	dim[IoAvsMaxDim];
	int	nspace;
	int	veclen;
	char	data_type[Imax_length_data_type];
	bool	flag_xdr;
	int	skip;
	char	uniform[12];
	AvsFileType	filetype;
	char	ext_name[256];
	char	*comment;
	char	**filenames;
	int	nfile;
} AvsHead;
	extern AvsHead *avs_fread_head(FILE *, cchar *, cint);
	extern bool io_avs_free(AvsHead *);
#endif

/* Source: ../io/avs/decs-io-avs.h */
#ifndef DecsIoAvs
#define DecsIoAvs
extern void	io_avs_help(void);
extern bool	io_avs_header_dims(int *, int *, int *, int *, int *,
			char *, cchar *, cint);
extern bool	io_avs_read_4d(void *, cchar *, double *, char **,
			cint, cint, int, cint,
			cint, cint, cint, cint, cchar *, cbool, cbool, cint);
extern bool	io_avs_read_slice(void *, cchar *, cint, cint, cint, cchar *,
			cint);
extern bool	io_avs_write_us(cchar *, cvoid *, cchar *, cdouble, cchar *,
			cint *, cint, cbool, cint);
#endif

/* Source: ../io/cti/defs-io-cti.h */
#ifndef DefsCti
#define DefsCti
#if !defined(Cswaphead)
#define	Cswaphead	0
#endif
typedef enum {
	Cti_NoData, Cti_Sinogram, Cti_PetImage, Cti_AttenCor, Cti_Normalization,
	Cti_PolarMap, Cti_ByteVolume, Cti_PetVolume, Cti_ByteProjection,
	Cti_PetProjection, Cti_ByteImage, Cti_Short3dSinogram,
	Cti_Byte3dSinogram, Cti_Norm3d, Cti_Float3dSinogram, Cti_InterfileImage
} Cti_filetype;
#define CisScan3d(t)	((t) == Cti_Byte3dSinogram || (t) == Cti_Short3dSinogram || (t) == Cti_Float3dSinogram)
typedef enum {
	Cti_UnknownMatDataType, Cti_ByteData, Cti_VAX_Ix2, Cti_VAX_Ix4,
	Cti_VAX_Rx4, Cti_IeeeFloat, Cti_SunShort, Cti_SunLong,
	Cti_NumMatrixDataTypes, Cti_ColorData, Cti_BitData
} Cti_datatype;
typedef enum {
	Cti_NotProc=0, Cti_Norm=1,
	Cti_Atten_Meas=2, Cti_Atten_Calc=4,
	Cti_Smooth_X=8, Cti_Smooth_Y=16, Cti_Smooth_Z=32,
	Cti_Scat2d=64, Cti_Scat3d=128,
	Cti_ArcPrc=256, Cti_DecayPrc=512, Cti_OnComPrc=1024
} Cti_proccode;
typedef enum {
	Cti_UndefScan, Cti_BlankScan,
	Cti_TransmissionScan, Cti_StaticEmission,
	Cti_DynamicEmission, Cti_GatedEmission,
	Cti_TransRectilinear, Cti_EmissionRectilinear,
	Cti_NumScanTypes
} Cti_acquisition_type;
typedef enum {
	Cti_SrcNone, Cti_Rring, Cti_Ring, Cti_Rod, Cti_Rrod
} Cti_trantype;
typedef enum {
	Cti_NetTrue, Cti_PromptDelay, Cti_PromptDelayMult
} Cti_coinmode;
typedef enum {
	Cti_AcqNormal, Cti_RodTrn, Cti_RodTrnKeep,
	Cti_DwinKeep, Cti_Dwin, Cti_Simult
} Cti_acquisition_mode;
typedef enum {
	Cti_FiltNone, Cti_Ramp, Cti_Butter,
	Cti_Hann, Cti_Hamm, Cti_Parzen, Cti_Shepp
} Cti_filter;
#define c7_storage(i)	\
	(((i) == 1) ? "view" : \
	(((i) == 2) ? "sino" : \
	(((i) == 3) ? "view2sino" : \
	"unknown")))
#if Cswaphead == 0
	typedef struct {
		uint	frame : 12;
		uint	bed : 4;
		uint	plane : 8;
		uint	gate : 6;
		uint	data : 2;
	} Cid;
#elif Cswaphead == 1
	typedef struct {
		uint	data : 2;
		uint	gate : 6;
		uint	plane : 8;
		uint	bed : 4;
		uint	frame : 12;
	} Cid;
#else
#endif
typedef struct {
	Cid	cid;
	uint	record;
	uint	last;
	uint	status;
} Cmat;
typedef struct {
	uint	navail;
	uint	next;
	uint	prev;
	uint	nused;
	Cmat	cm[31];
} Cdir;
typedef struct {
	Cdir	*cd;
	int	ndir;
	int	nmat;
	Cid	min;
	Cid	max;
	bool	isv7;
	bool	swaphead;
	int	system;
	bool	septa_in_fov;
	int	angular_compression;
	float	calibration_factor;
	float	isotope_halflife;
	short	calibration_units;
	short	calibration_units_label;
	int	scan_start_time;
	char	study_type[13];
	char	study_desc[33];
	short	acquisition_type;
	short	acquisition_mode;
	Cti_filetype	filetype;
	Cti_datatype	datatype;
	enum	{Cframe4, Cgate4, Cbed4} type4;
	int	span;
	int	ring_diff;
	int	nsegment;
	int	nz[64];
	int	nzsum;
	enum	{Corder_unknown, Corder_view, Corder_sino, Corder_view2sino}
		storage_order;
} Cdirs;
typedef struct {
	int transaxial_crystals;
	int axial_crystals;
	int block_rings;
	int crystal_rings;
	int crystals_per_ring;
	int nc;
	int blocks_per_bucket;
	int crystals_per_bucket;
	int buckets_per_ring;
} Cmodel;
extern cchar	*cti_get_str(cbyte *, cint);
extern short	cti_get_i2(cbyte *, cbool);
extern int	cti_get_i4(cbyte *, cbool);
extern float	cti_get_ieee_float(cbyte *, cbool);
extern float	cti_get_vaxfloat(cbyte *, cbool);
extern void	cti_get_vaxfloats(float *, cfloat *, int, cbool);
extern void	cti_put_vaxfloat(byte *, cfloat *, int, cbool);
extern bool	cti_dims(int *, int *, int *, int *, int *,
			Cdirs *, FILE *, cint);
extern Cdirs	*cti_dir_set(cint, cint, cint);
extern void	cti_main_head(byte *, cint, cint, cchar *type, cbool);
extern void	cti_head_img(byte *, cint, cint, cdouble, cbool);
extern bool	cti_model(Cmodel *, cint, cint);
extern Cdirs	*cti_dir_read(FILE *, cbool, cint);
extern bool	cti_dir_free(Cdirs *);
extern bool	cti_get_buff_sub(byte *, FILE *, Cdirs *, cint, cbool);
extern bool	cti_get_short_sub(short *, FILE *, cint, Cdirs *, cint);
extern bool	cti_set_file_datatype(Cdirs *, FILE *, cint);
extern bool	cti_mat_range(Cid *, Cid *, Cdirs *, cint chat);
extern uint	cti_get_rec(cint, cint, cint, Cdirs *);
extern bool	cti_get_dims(int *, int *, int *, FILE *, Cdirs *, cint);
extern bool	cti_get_scale(double *, cint, cint, cint, Cdirs *, FILE *);
extern cchar	*c7_filetype(cint);
extern cchar	*c7_acquisition_type(cint);
extern cchar	*c7_datatype(cint);
extern cchar	*c7_corrappl(cint);
extern cchar	*c7_acquisition_mode(cint);
extern cchar	*c7_trantype(cint);
extern cchar	*c7_coinmode(cint);
extern cchar	*c7_filter(cint);
extern cchar	*c7_calunit(cint);
extern cchar	*c7_calstat(cint);
#endif

/* Source: ../io/cti/decs-io-cti.h */
#ifndef DecsIoCti
#define DecsIoCti
extern bool	io_cti_head(int *, int *, int *, int *, int *, char *, cchar *, cint);
extern bool	io_cti_norm2_file(cchar *, cchar *, cchar *, cchar *, cint);
extern bool	io_cti_read(void *, cchar *, double *, cint, cint, int, int, int,
			cint, cint, int, int, int, int, cchar *, cbool, cbool, cint);
extern bool	io_cti_write(cchar *, cchar *, cchar *, cvoid *, cchar *,
			cdouble, cint, cint, cint, cint, cint, cint);
extern bool	io_cti_show_header_file(cchar *, cint, cbool, cint);
extern bool	io_cti_value_file(cchar *, cchar *, cint, cint);
#endif

/* Source: ../io/mat/defs-matlab.h */
#ifndef DEFS_MATLAB
#define DEFS_MATLAB
#ifndef MatlabEndian
#	define MatlabEndian	io_cpu_has_xdr_byte_order()
#endif
typedef struct {
	int type;
	int mrows;
	int ncols;
	int imagf;
	int namlen;
} Fmatrix;
#define Fmatrix_defined
extern bool	loadmat(FILE *, int *, char *, int *, int *, int *, double **, double **);
extern bool	savemat(FILE *, cint, cchar *, cint, cint, cint, cdouble *, cdouble *);
#endif

/* Source: ../io/mat/decs-io-mat.h */
#ifndef DecsIoMat
#define DecsIoMat
extern bool	io_matlab_read3(double **, int *, int *, int *, cchar *, cchar *, cint);
extern bool	io_matlab_head(int *, int *, int *, int *, cchar *, cchar *, cint);
extern bool	io_matlab_read(void *, cchar *, double *,
			cint, cint, cint, cint, int, int, int, int,
			cchar *, cchar *, cbool, cbool, cint);
extern bool	io_matlab_write(cchar *file, cchar *name,
			cint, cint, cint, cint,
			cvoid *data, cchar *type, cdouble scale, cint);
bool matls_file(cint, pcpcchar, cint);
#endif

/* Source: ../io/pgm/decs-io-pgm.h */
extern bool io_gif_write(cchar *, cvoid *, cchar *, cint, cint, cint, cint);
extern bool io_pgm_header_dims(int *, int *, cchar *);
extern bool io_pgm_read(
void	*data,
cchar	*data_type,
double	*scale_out,
cint	nx,
cint	ny,
cchar	*file,
cint	chat);
extern bool io_pgm_append(
FILE	*fp,
cint	nx,
cint	ny,
cvoid	*data,
cchar	*data_type,
cint	chat);
extern bool io_pgm_write(
cchar	*file,
cint	nx,
cint	ny,
cint	nz,
cvoid	*data,
cchar	*data_type,
cint	chat);
extern bool io_ppm_append(
FILE	*fp,
cint	nx,
cint	ny,
cvoid	*data,
cchar	*data_type,
cint	chat);
extern bool io_ppm_write(
cchar	*file,
cint	nx,
cint	ny,
cint	nz,
cvoid	*data,
cchar	*data_type,
cint	chat);
