/*
*	def,subset.h
*	structure for controlling subsets
*
*	Copyright 2001-07-13	Jeff Fessler	The University of Michigan
*/


typedef struct {
	enum {
		SubsetError,	/* 0 indicates error */
		SubsetUnif,	/* uniformly spaced views */
		SubsetList	/* arbitrary list of views */
	} type;

	int	istart;		/* for uniform spaced subsets */
	int	nsubset;
	byte	*list;		/* [nview] binary,
					indicating if each view is to be used */
} Subsets;

typedef const Subsets cSubsets;

#define Subsets_is_unif(s)	((s)->type == SubsetUnif)
#define Subsets_is_list(s)	((s)->type == SubsetList)
#define Subsets_use_view(s, iv)	(!(s) || !Subsets_is_list(s) || (s)->list[iv])

